/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.overthere;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService;
import com.xebialabs.xlrelease.storage.domain.LogEntry;
import java.io.OutputStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Option;

class TaskExecutionLogOutputStream
extends OutputStream {
    private final TaskExecutionLogService taskExecutionLogService;
    private final AtomicInteger chunk = new AtomicInteger(0);
    private final Task task;

    TaskExecutionLogOutputStream(TaskExecutionLogService taskExecutionLogService, Task task) {
        this.taskExecutionLogService = taskExecutionLogService;
        this.task = task;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (len > 0) {
            LogEntry entry = new LogEntry(this.task.getId(), this.task.getExecutionId(), (long)this.task.getFailuresCount(), (long)this.chunk.incrementAndGet(), DateTimeFormatter.ISO_INSTANT.format(Instant.now()), Arrays.copyOf(b, len), Option.empty());
            this.taskExecutionLogService.log(entry);
        }
    }

    @Override
    public void write(int i) {
        throw new UnsupportedOperationException("Should not write a line with byte by byte when handling log files");
    }
}

