/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.overthere;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.plugin.overthere.TaskExecutionLogOutputStream;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService;
import com.xebialabs.xlrelease.storage.service.LogSizeLimitExceededException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskExecutionLogHelper
extends BufferedOutputStream {
    private static final Logger logger = LoggerFactory.getLogger(TaskExecutionLogHelper.class);
    private final Timer timer;
    private volatile boolean running = true;

    public TaskExecutionLogHelper(Task task, TaskExecutionLogOutputStream outputStream, Duration pollingInterval) {
        super(outputStream, TaskExecutionLogService.DEFAULT_CHUNK_BUFFER_SIZE());
        this.timer = new Timer("task-execution-log-" + task.getExecutionId() + "-" + task.getFailuresCount(), true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                TaskExecutionLogHelper.this.flushBuffer();
            }
        }, 0L, pollingInterval.toMillis());
    }

    public void log(String line) {
        if (!this.running) {
            logger.debug("Log helper no longer running, skipping the line");
            return;
        }
        try {
            this.write(line.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.error("Failed to log a line", (Throwable)e);
        }
        catch (LogSizeLimitExceededException ex) {
            logger.debug("Log size limit exceeded", (Throwable)ex);
            this.stop();
        }
    }

    public void flushBuffer() {
        try {
            this.flush();
        }
        catch (IOException e) {
            logger.error("Failed to flush the buffer", (Throwable)e);
        }
    }

    public void stop() {
        this.timer.cancel();
        this.timer.purge();
        this.running = false;
    }

    @Override
    public void close() throws IOException {
        this.stop();
        super.close();
    }
}

