/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.overthere;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService;
import com.xebialabs.xlrelease.storage.domain.LogEntry;
import com.xebialabs.xlrelease.storage.service.LogSizeLimitExceededException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

class TaskExecutionLogHelper
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TaskExecutionLogHelper.class);
    private final Task task;
    private final int bufferSize;
    private final Timer timer;
    private final TaskExecutionLogService taskExecutionLogService;
    private final AtomicInteger chunk = new AtomicInteger(0);
    private final ByteArrayOutputStream byteArrayOutputStream;
    private final BufferedOutputStream outputStream;
    private volatile boolean running = true;
    private int currentBufferSize = 0;

    public TaskExecutionLogHelper(Task task, TaskExecutionLogService taskExecutionLogService) {
        this.task = task;
        this.bufferSize = TaskExecutionLogService.DEFAULT_CHUNK_BUFFER_SIZE();
        this.byteArrayOutputStream = new ByteArrayOutputStream(this.bufferSize * 2);
        this.outputStream = new BufferedOutputStream(this.byteArrayOutputStream, this.bufferSize);
        this.taskExecutionLogService = taskExecutionLogService;
        this.timer = new Timer("task-execution-log-" + task.getExecutionId() + "-" + task.getFailuresCount(), true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                TaskExecutionLogHelper.this.flushBuffer();
            }
        }, 0L, 5000L);
    }

    public void log(String line) {
        if (!this.running) {
            logger.debug("Log helper no longer running, skipping the line");
            return;
        }
        try {
            this.append(line.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.error("Failed to log a line", (Throwable)e);
        }
    }

    public void flushBuffer() {
        try {
            this.outputStream.flush();
            byte[] currentBuffer = this.byteArrayOutputStream.toByteArray();
            this.byteArrayOutputStream.reset();
            this.currentBufferSize = 0;
            if (currentBuffer.length > 0) {
                LogEntry entry = new LogEntry(this.task.getId(), this.task.getExecutionId(), (long)this.task.getFailuresCount(), (long)this.chunk.incrementAndGet(), DateTimeFormatter.ISO_INSTANT.format(Instant.now()), currentBuffer, Option.empty());
                this.taskExecutionLogService.log(entry);
            }
        }
        catch (IOException e) {
            logger.error("Failed to flush the buffer", (Throwable)e);
        }
        catch (LogSizeLimitExceededException ex) {
            logger.debug("Log size limit exceeded", (Throwable)ex);
            this.stop();
        }
    }

    public void stop() {
        this.timer.cancel();
        this.running = false;
    }

    private void append(byte[] payload) throws IOException {
        this.outputStream.write(payload);
        this.currentBufferSize += payload.length;
        if (this.currentBufferSize > this.bufferSize) {
            this.flushBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        this.stop();
        this.outputStream.close();
    }
}

