package com.xebialabs.xlrelease.plugin.overthere;

import java.io.IOException;

class PasswordMaskingOutputHandler implements OutputHandler {
    private final OutputHandler outputHandler;
    private final PasswordMasker masker;

    public PasswordMaskingOutputHandler(OutputHandler outputHandler, PasswordMasker passwordMasker) {
        this.outputHandler = outputHandler;
        this.masker = passwordMasker;
    }

    @Override
    public void handleChar(final char c) {
        // no op
    }

    @Override
    public void handleLine(final String lineWithoutEnding) {
        var line = lineWithoutEnding + NL;
        String masked = masker.maskPassword(line);
        if (this.outputHandler != null) {
            this.outputHandler.handleLine(masked);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.outputHandler != null) {
            outputHandler.close();
        }
    }


    @Override
    public String getStringContent() throws IOException {
        if (null != outputHandler) {
            return outputHandler.getStringContent();
        } else {
            throw new IOException("OutputHandler is not defined");
        }
    }

}
