package com.xebialabs.xlrelease.plugin.overthere;

import java.util.Set;
import java.util.stream.Collectors;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Task;

import static com.xebialabs.xlrelease.utils.PasswordVerificationUtils.PASSWORD_MASK;

class PasswordMasker {
    final Set<String> passwordValues;

    public PasswordMasker(Task task) {
        var configurationItem = task instanceof CustomScriptTask t ? t.getPythonScript() : task;
        this.passwordValues = configurationItem.getType().getDescriptor()
                .getPropertyDescriptors()
                .stream()
                .filter(pd -> pd.isPassword() && pd.getKind() == PropertyKind.STRING)
                .map(pd -> (String) pd.get(configurationItem))
                .filter(Strings::isNotBlank)
                .collect(Collectors.toSet());
    }

    public String maskPassword(String line) {
        String acc = line;
        for (String passwordValue : passwordValues) {
            acc = acc.replace(passwordValue, PASSWORD_MASK());
        }
        return acc;
    }
}
