package com.xebialabs.xlrelease.plugin.overthere;

import java.io.IOException;

class TaskExecutionLogOutputHandler implements OutputHandler {

    private final OutputHandler outputHandler;
    private final TaskExecutionLogHelper logHelper;

    public TaskExecutionLogOutputHandler(OutputHandler outputHandler, TaskExecutionLogHelper logHelper) {
        this.outputHandler = outputHandler;
        this.logHelper = logHelper;
    }

    @Override
    public void handleChar(final char c) {
        // no-op
    }

    @Override
    public void handleLine(final String line) {
        if (null != outputHandler) {
            outputHandler.handleLine(line);
        }
        logHelper.log(line);
    }

    @Override
    public void close() throws IOException {
        try {
            logHelper.close();
        } finally {
            if (null != outputHandler) {
                outputHandler.close();
            }
        }
    }

    @Override
    public String getStringContent() throws IOException {
        if (null != outputHandler) {
            return outputHandler.getStringContent();
        } else {
            throw new IOException("OutputHandler is not defined");
        }
    }

}
