package com.xebialabs.xlrelease.plugin.overthere;

import java.io.IOException;

class TaskExecutionLogOutputHandler extends AbstractOutputHandler {
    private final TaskExecutionLogHelper logHelper;

    public TaskExecutionLogOutputHandler(OutputHandler outputHandler, TaskExecutionLogHelper logHelper) {
        super(outputHandler);
        this.logHelper = logHelper;
    }

    @Override
    public void handleChar(final char c) {
        // no-op
    }

    @Override
    public void handleLine(final String line) {
        if (null != outputHandler) {
            outputHandler.handleLine(line);
        }
        logHelper.log(line);
    }

    @Override
    public void close() throws IOException {
        try {
            logHelper.close();
        } finally {
            super.close();
        }
    }

}
