/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.overthere.util;

import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService;
import com.xebialabs.xlrelease.scheduler.storage.spring.StorageConfiguration;
import com.xebialabs.xlrelease.storage.domain.LogEntry;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutionLogHelper {
    private static final Logger logger = LoggerFactory.getLogger(TaskExecutionLogHelper.class);
    private static final int BUFFER_SIZE = 8192;
    private final PythonScript pythonScript;
    private final TaskExecutionLogService taskExecutionLogService;
    private final AtomicInteger chunk = new AtomicInteger(0);
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
    private final BufferedOutputStream outputStream = new BufferedOutputStream(this.byteArrayOutputStream, 8192);
    private final Timer timer = new Timer();
    private int currentBufferSize = 0;

    public TaskExecutionLogHelper(PythonScript pythonScript, TaskExecutionLogService taskExecutionLogService) {
        this.pythonScript = pythonScript;
        this.taskExecutionLogService = taskExecutionLogService;
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                TaskExecutionLogHelper.this.flushBuffer();
            }
        }, 0L, 5000L);
    }

    public void log(String line) {
        String lineWithEnding = line.concat(System.getProperty("line.separator"));
        try {
            this.append(lineWithEnding.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.error("Failed to log a line", (Throwable)e);
        }
    }

    public void flushBuffer() {
        try {
            this.outputStream.flush();
            byte[] currentBuffer = this.byteArrayOutputStream.toByteArray();
            this.byteArrayOutputStream.reset();
            this.currentBufferSize = 0;
            if (currentBuffer.length > 0) {
                CustomScriptTask customScriptTask = this.pythonScript.getCustomScriptTask();
                this.taskExecutionLogService.log(new LogEntry(customScriptTask.getId(), customScriptTask.getExecutionId(), (long)customScriptTask.getFailuresCount(), (long)this.chunk.incrementAndGet(), DateTimeFormatter.ISO_INSTANT.format(Instant.now()), currentBuffer, StorageConfiguration.URI_SCHEME_LOCAL_STORAGE()));
            }
        }
        catch (IOException e) {
            logger.error("Failed to flush the buffer", (Throwable)e);
        }
    }

    public void stopTimer() {
        this.timer.cancel();
    }

    private void append(byte[] payload) throws IOException {
        this.outputStream.write(payload);
        this.currentBufferSize += payload.length;
        if (this.currentBufferSize > 8192) {
            this.flushBuffer();
        }
    }
}

