package com.xebialabs.xlrelease.plugin.overthere.util;

import java.util.Set;
import java.util.stream.Collectors;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.xlrelease.domain.PythonScript;

import static com.xebialabs.deployit.booter.local.utils.Strings.isNotBlank;
import static com.xebialabs.xlrelease.utils.PasswordVerificationUtils.PASSWORD_MASK;

public class RemoteScriptPasswordMasker {

    final Set<String> passwordProperties;

    public RemoteScriptPasswordMasker(PythonScript pythonScript) {
        this.passwordProperties = pythonScript.getType().getDescriptor()
                .getPropertyDescriptors()
                .stream()
                .filter(pd -> pd.isPassword() && pd.getKind() == PropertyKind.STRING)
                .map(PropertyDescriptor::getName)
                .collect(Collectors.toSet());
    }

    public String maskPassword(PythonScript pythonScript, String line) {
        for (String prop: passwordProperties) {
            if (pythonScript.hasProperty(prop) && isNotBlank(pythonScript.getProperty(prop))) {
                return line.replace(pythonScript.getProperty(prop), PASSWORD_MASK());
            }
        }
        return line;
    }
}
