package com.xebialabs.xlrelease.plugin.overthere.util;

import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.CapturingOverthereExecutionOutputHandler;
import com.xebialabs.xlrelease.domain.PythonScript;

public class StorageOutputHandler implements OverthereExecutionOutputHandler {

    private final CapturingOverthereExecutionOutputHandler stdOut;
    private final CapturingOverthereExecutionOutputHandler stdErr;
    private final TaskExecutionLogHelper taskExecutionLogHelper;
    private final RemoteScriptPasswordMasker remoteScriptPasswordMasker;
    private final PythonScript pythonScript;
    private final boolean isErrorHandler;

    public StorageOutputHandler(PythonScript pythonScript, TaskExecutionLogHelper taskExecutionLogHelper, boolean isErrorHandler) {
        this.pythonScript = pythonScript;
        this.taskExecutionLogHelper = taskExecutionLogHelper;
        this.isErrorHandler = isErrorHandler;
        this.stdOut = CapturingOverthereExecutionOutputHandler.capturingHandler();
        this.stdErr = CapturingOverthereExecutionOutputHandler.capturingHandler();
        this.remoteScriptPasswordMasker = new RemoteScriptPasswordMasker(pythonScript);
    }

    @Override
    public void handleChar(char c) {
        // no-op
    }

    @Override
    public void handleLine(String line) {
        String lineWithMaskedPasswords = this.remoteScriptPasswordMasker.maskPassword(this.pythonScript, line);
        if (isErrorHandler) {
            stdErr.handleLine(lineWithMaskedPasswords);
        } else {
            stdOut.handleLine(lineWithMaskedPasswords);
        }
        taskExecutionLogHelper.log(lineWithMaskedPasswords);
    }


    public String getOutput() {
        if (isErrorHandler) {
            return stdErr.getOutput();
        } else {
            return stdOut.getOutput();
        }
    }

}
