/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.overthere.util;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils;
import java.util.Set;
import java.util.stream.Collectors;

public class RemoteScriptPasswordMasker {
    final Set<String> passwordProperties;

    public RemoteScriptPasswordMasker(PythonScript pythonScript) {
        this.passwordProperties = pythonScript.getType().getDescriptor().getPropertyDescriptors().stream().filter(pd -> pd.isPassword() && pd.getKind() == PropertyKind.STRING).map(PropertyDescriptor::getName).collect(Collectors.toSet());
    }

    public String maskPassword(PythonScript pythonScript, String line) {
        for (String prop : this.passwordProperties) {
            if (!pythonScript.hasProperty(prop) || !Strings.isNotBlank((String)((String)pythonScript.getProperty(prop)))) continue;
            return line.replace((CharSequence)pythonScript.getProperty(prop), PasswordVerificationUtils.PASSWORD_MASK());
        }
        return line;
    }
}

