import sys
import string
from com.xebialabs.xlrelease.plugin.overthere import RemoteScript

def isNotBlank(passwordString):
    return bool(passwordString and passwordString.strip())

def maskPasswordValue(input, propertyName):
    if task.pythonScript.hasProperty(propertyName) and isNotBlank(task.pythonScript.getProperty(propertyName)):
        return string.replace(input, task.pythonScript.getProperty(propertyName), '********')
    else:
        return input

script = RemoteScript(task.pythonScript)
exitCode = script.execute()

# Mask passwords
output = script.getStdout()
err = script.getStderr()

# list of password kind property for remote script tasks
passwordProperties = ['password', 'privateKey', 'passphrase', 'suPassword']

for property in passwordProperties:
    output = maskPasswordValue(output, property)
    err = maskPasswordValue(err, property)

if (exitCode == 0):
    print output
else:
    print "Exit code "
    print exitCode
    print
    print "#### Output:"
    print output

    print "#### Error stream:"
    print err
    print
    print "----"

    sys.exit(exitCode)
