/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.util;

import com.xebialabs.xlrelease.notifications.email.Email;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.exception.ExceptionUtils;

public class FunctionalUtils {
    private static final Pattern pOpeningTagPattern = Pattern.compile("<p>");
    private static final Pattern pClosingTagPattern = Pattern.compile("</p>");
    public static final Function<Throwable, String> getNestedExceptionsMessagesFunction = ex -> Arrays.stream(ExceptionUtils.getThrowables((Throwable)ex)).map(Throwable::getMessage).collect(Collectors.joining("; "));
    public static final Consumer<Throwable> nestedExceptionsWithThrowableConsumer = ex -> {
        String msg = getNestedExceptionsMessagesFunction.apply((Throwable)ex);
        throw new IllegalArgumentException(msg);
    };
    public static final Function<Email, Stream<String>> emailRecipientMapper = email -> email.getRecipients().stream();
    public static final BiFunction<Email, Map<String, String>, List<String>> getUserFromEmailBiFunction = (email, emailToUserMap) -> emailRecipientMapper.apply((Email)email).map(emailToUserMap::get).collect(Collectors.toList());
    public static final Function<String, String> removeFirstOpeningAndClosingPTags = html -> Optional.ofNullable(html).filter(s -> !s.isEmpty()).map(s -> s.replaceFirst(pOpeningTagPattern.pattern(), "")).map(s -> {
        int index = s.lastIndexOf(pClosingTagPattern.pattern());
        if (index == -1) {
            return s;
        }
        return new StringBuilder((String)s).replace(index, index + pClosingTagPattern.pattern().length(), "").toString();
    }).orElse((String)html);

    private FunctionalUtils() {
    }
}

