/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.google.common.base.Strings;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.ImapServer;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImapTokenHelper {
    private static final Logger logger = LoggerFactory.getLogger(ImapTokenHelper.class);
    private Duration clockSkew = Duration.ofSeconds(60L);
    private Clock clock = Clock.systemUTC();
    private ConfigurationRepository configurationRepository;

    @Autowired
    public ImapTokenHelper(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
    }

    public ImapTokenHelper() {
    }

    public void refreshTokenIfRequired(ImapServer imapServer, boolean decryptPassword) throws Exception {
        if (Strings.isNullOrEmpty((String)imapServer.getRefreshToken()) || Strings.isNullOrEmpty((String)imapServer.getAccessTokenUrl()) || Strings.isNullOrEmpty((String)imapServer.getClientId()) || Strings.isNullOrEmpty((String)imapServer.getClientSecret())) {
            throw new IllegalArgumentException("The Access Token Url, Client Id, Client Secret, and Refresh Token must not be null or empty.");
        }
        if (Strings.isNullOrEmpty((String)imapServer.getAccessToken()) || this.hasTokenExpired(imapServer).booleanValue()) {
            logger.debug("Going to generate a new access token");
            AccessToken accessToken = this.doRefresh(imapServer, decryptPassword);
            imapServer.setAccessToken(PasswordEncrypter.getInstance().encrypt(accessToken.getValue()));
            if (accessToken.getLifetime() > 0L) {
                imapServer.setExpiresAt(Date.from(Instant.now().plusSeconds(accessToken.getLifetime())));
            } else {
                imapServer.setExpiresAt(Date.from(Instant.now().plusSeconds(1L)));
            }
            if (this.configurationRepository != null && !Strings.isNullOrEmpty((String)imapServer.getId()) && this.configurationRepository.exists(imapServer.getId())) {
                this.configurationRepository.update((BaseConfiguration)imapServer);
            }
        }
    }

    private Boolean hasTokenExpired(ImapServer imapServer) throws Exception {
        if (imapServer.getExpiresAt() != null) {
            return this.clock.instant().isAfter(imapServer.getExpiresAt().toInstant().minus(this.clockSkew));
        }
        return true;
    }

    private AccessToken doRefresh(ImapServer imapServer, boolean decryptPassword) throws Exception {
        String refreshTokenValue = decryptPassword ? PasswordEncrypter.getInstance().decrypt(imapServer.getRefreshToken()) : imapServer.getRefreshToken();
        String clientSecretValue = decryptPassword ? PasswordEncrypter.getInstance().decrypt(imapServer.getClientSecret()) : imapServer.getClientSecret();
        RefreshToken refreshToken = new RefreshToken(refreshTokenValue);
        RefreshTokenGrant refreshTokenGrant = new RefreshTokenGrant(refreshToken);
        ClientID clientID = new ClientID(imapServer.getClientId());
        Secret clientSecret = new Secret(clientSecretValue);
        ClientSecretPost clientAuth = new ClientSecretPost(clientID, clientSecret);
        URI tokenEndpoint = new URI(imapServer.getAccessTokenUrl());
        TokenRequest request = new TokenRequest(tokenEndpoint, (ClientAuthentication)clientAuth, (AuthorizationGrant)refreshTokenGrant);
        TokenResponse response = TokenResponse.parse((HTTPResponse)request.toHTTPRequest().send());
        logger.debug("Refresh token response from server: {}", (Object)response.toHTTPResponse().getContent());
        if (!response.indicatesSuccess()) {
            TokenErrorResponse errorResponse = response.toErrorResponse();
            throw new RuntimeException("An error occurred while attempting to get the new OAuth 2.0 Access Token: [" + errorResponse.getErrorObject().getCode() + "] " + errorResponse.getErrorObject().getDescription());
        }
        AccessTokenResponse successResponse = response.toSuccessResponse();
        AccessToken accessToken = successResponse.getTokens().getAccessToken();
        return accessToken;
    }
}

