/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.xebialabs.xlrelease.plugins.remotecompletion.email.EmailAttachment;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.HandleFeedbackService;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageReader {
    private static final Logger logger = LoggerFactory.getLogger(MessageReader.class);
    private final HandleFeedbackService handleFeedbackService;

    @Autowired
    public MessageReader(HandleFeedbackService handleFeedbackService) {
        this.handleFeedbackService = handleFeedbackService;
    }

    public String getEmailBody(Message message, String fromEmail) {
        StringBuilder result = new StringBuilder();
        try {
            result.append(this.getParts((Part)message, fromEmail));
        }
        catch (Exception ex) {
            logger.error("Error while reading body", (Throwable)ex);
            this.handleFeedbackService.sendMailAndThrowException("Unsupported mail format received.", fromEmail);
        }
        logger.trace("Message body read. data: [{}]", (Object)result);
        return result.toString();
    }

    public List<EmailAttachment> getEmailAttachments(Message message, String fromEmail) {
        ArrayList<EmailAttachment> attachments = new ArrayList<EmailAttachment>();
        try {
            attachments.addAll(this.getAttachments((Part)message, fromEmail));
        }
        catch (Exception getEmailException) {
            logger.error("Error while retrieving attachments", (Throwable)getEmailException);
        }
        logger.trace("Finished getEmailAttachments");
        return attachments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EmailAttachment> getAttachments(Part part, String fromEmail) throws IOException, MessagingException {
        logger.trace("In getAttachments");
        new StringBuilder();
        ArrayList<EmailAttachment> attachments = new ArrayList<EmailAttachment>();
        Object contentObject = part.getContent();
        if (contentObject instanceof Multipart) {
            Multipart content = (Multipart)contentObject;
            int count = content.getCount();
            logger.trace("Finding Attachments. Content type: {} number of parts: {}", (Object)content.getContentType(), (Object)count);
            for (int i = 0; i < count; ++i) {
                BodyPart innerPart = content.getBodyPart(i);
                if (innerPart.isMimeType("multipart/alternative")) {
                    logger.trace("Recursively reading body part.");
                    attachments.addAll(this.getAttachments((Part)innerPart, fromEmail));
                    continue;
                }
                if (innerPart.getDisposition() != null && innerPart.getDisposition().equals("attachment")) {
                    String fileName = innerPart.getFileName();
                    logger.trace("Found attachment, fileName is {} will save to byte[]", (Object)fileName);
                    try {
                        Throwable throwableObject = null;
                        Object object = null;
                        try {
                            InputStream stream = innerPart.getInputStream();
                            try {
                                BufferedInputStream in = new BufferedInputStream(stream, 32768);
                                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                                    int size;
                                    byte[] dataBuffer = new byte[16384];
                                    boolean booleanObject = false;
                                    while ((size = in.read(dataBuffer)) != -1) {
                                        out.write(dataBuffer, 0, size);
                                    }
                                    byte[] bytes = out.toByteArray();
                                    EmailAttachment theAttachment = new EmailAttachment(fileName, bytes);
                                    attachments.add(theAttachment);
                                }
                                catch (Throwable e) {
                                    if (throwableObject == null) {
                                        throwableObject = e;
                                    } else if (throwableObject != e) {
                                        throwableObject.addSuppressed(e);
                                    }
                                    if (in != null) {
                                        in.close();
                                    }
                                    throw throwableObject;
                                }
                                if (in != null) {
                                    in.close();
                                }
                            }
                            catch (Throwable secondThrowableObject) {
                                if (throwableObject == null) {
                                    throwableObject = secondThrowableObject;
                                } else if (throwableObject != secondThrowableObject) {
                                    throwableObject.addSuppressed(secondThrowableObject);
                                }
                                if (stream != null) {
                                    stream.close();
                                }
                                throw throwableObject;
                            }
                            if (stream == null) continue;
                            stream.close();
                        }
                        catch (Throwable thirdThrowableObject) {
                            if (throwableObject == null) {
                                throwableObject = thirdThrowableObject;
                            } else if (throwableObject != thirdThrowableObject) {
                                throwableObject.addSuppressed(thirdThrowableObject);
                            }
                            throw throwableObject;
                        }
                    }
                    catch (Exception fourthThrowableObject) {
                        logger.error("Error while reading attachment for file {}, exception is {}", (Object)fileName, (Object)fourthThrowableObject);
                    }
                    catch (Throwable fifthThrowableObject) {
                        logger.error("Error while reading attachment for file {}, exception is {}", (Object)fileName, (Object)fifthThrowableObject);
                    }
                    continue;
                }
                if (!innerPart.isMimeType("text/plain") && !innerPart.isMimeType("text/html")) {
                    logger.trace("Ignoring unsupported body part with content type: {}", (Object)innerPart.getContentType());
                    continue;
                }
                logger.trace("innerPart is text not attachment, ignoring");
            }
        }
        return attachments;
    }

    private String getParts(Part part, String fromEmail) throws IOException, MessagingException {
        StringBuilder result = new StringBuilder();
        Object contentObject = part.getContent();
        if (contentObject instanceof Multipart) {
            Multipart content = (Multipart)contentObject;
            int count = content.getCount();
            logger.trace("Reading message. Content type: {} number of parts: {}", (Object)content.getContentType(), (Object)count);
            for (int i = 0; i < count; ++i) {
                BodyPart innerPart = content.getBodyPart(i);
                if (innerPart.isMimeType("multipart/alternative")) {
                    logger.trace("Recursively reading body part.");
                    result.append(this.getParts((Part)innerPart, fromEmail));
                    continue;
                }
                if (innerPart.getDisposition() != null && innerPart.getDisposition().equals("attachment")) {
                    logger.trace("Skipping attachment");
                    continue;
                }
                if (innerPart.isMimeType("text/plain") || innerPart.isMimeType("text/html")) {
                    logger.trace("Appending part to read body. Content type: {} data: [{}]", (Object)innerPart.getContentType(), innerPart.getContent());
                    result.append(innerPart.getContent());
                    continue;
                }
                logger.trace("Ignoring unsupported body part with content type: {}", (Object)innerPart.getContentType());
            }
        } else if (contentObject instanceof String) {
            result.append(contentObject);
        } else {
            this.handleFeedbackService.sendMailAndThrowException("Unsupported mail format received.", fromEmail);
            logger.trace("Unsupported message with content type: {}", (Object)part.getContentType());
        }
        return result.toString();
    }
}

