/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.HandleFeedbackService;
import com.xebialabs.xlrelease.service.UserProfileService;
import java.util.Optional;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReleaseLicenseService {
    private static final Logger logger = LoggerFactory.getLogger(ReleaseLicenseService.class);
    private HandleFeedbackService handleFeedbackService;
    private UserProfileService userProfileService;

    @Autowired
    public ReleaseLicenseService(HandleFeedbackService handleFeedbackService, UserProfileService userProfileService) {
        this.handleFeedbackService = handleFeedbackService;
        this.userProfileService = userProfileService;
    }

    public void validateAssigneeLicense(String assignee, String fromEmail, Task task) {
        if (assignee != null) {
            Optional.ofNullable(this.userProfileService.discover(assignee)).filter(this::licensedUsers).ifPresentOrElse(up -> this.updateLastActive(assignee, (UserProfile)up), () -> this.noLicenseAvailable(assignee, fromEmail, task));
        }
    }

    private boolean licensedUsers(UserProfile userProfile) {
        return userProfile.getLastActive() != null || this.userProfileService.areLicensesAvailable();
    }

    private void updateLastActive(String assignee, UserProfile userProfile) {
        if (userProfile.getLastActive() == null) {
            logger.debug("Allocating license for user {}.", (Object)assignee);
            userProfile.setLastActive(DateTime.now().toDate());
            this.userProfileService.updateLastActive(userProfile.getCanonicalId(), DateTime.now().toDate(), Boolean.valueOf(true));
        } else {
            this.userProfileService.updateLastActive(userProfile.getCanonicalId(), DateTime.now().toDate(), Boolean.valueOf(false));
        }
    }

    private void noLicenseAvailable(String assignee, String fromEmail, Task task) {
        logger.error("User {} does not have a license and there are no available seats left under your Release license. Please contact your Release administrator for further assistance.", (Object)assignee);
        this.handleFeedbackService.sendMailAndThrowException(String.format("There are no available seats left under your Release license for user: %s. Please contact your Release administrator for further assistance.", assignee), fromEmail, Optional.of(task));
    }
}

