/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.notifications.email.Email;
import com.xebialabs.xlrelease.notifications.email.EmailSender;
import com.xebialabs.xlrelease.plugins.remotecompletion.context.EmailContext;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.EmailBuilder;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HandleFeedbackService {
    private static final Logger logger = LoggerFactory.getLogger(HandleFeedbackService.class);
    private EmailSender emailSender;
    private EmailContext emailContext;

    @Autowired
    public HandleFeedbackService(EmailSender emailSender, EmailContext emailContext) {
        this.emailSender = emailSender;
        this.emailContext = emailContext;
    }

    public void sendMailAndThrowException(String errorMsg, String fromEmail) {
        this.sendMailAndThrowException(errorMsg, fromEmail, Optional.empty());
    }

    public void sendMailAndThrowException(String errorMsg, String fromEmail, Optional<Task> task) {
        Email email = EmailBuilder.buildFeedbackEmail(task, this.emailContext.buildFeedbackContext(errorMsg, task), Arrays.asList(fromEmail), "remote-completion-feedback-template.mustache");
        this.emailSender.scheduleEmail(email).handle((res, ex) -> {
            if (ex != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Sending email to {} failed", (Object)String.join((CharSequence)", ", email.getRecipients()));
                }
                return null;
            }
            return null;
        });
        throw new IllegalStateException(errorMsg);
    }
}

