/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.ci;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.Configuration;
import java.util.Date;
import java.util.List;

@Metadata(root=Metadata.ConfigurationItemRoot.CONFIGURATION, label="Remote Completion: IMAP Server", versioned=false)
public class ImapServer
extends Configuration {
    @Property(hidden=true, defaultValue="remotecompletion/EmailConnectionCheck.py")
    private String scriptLocation;
    @Property(description="IMAP server host")
    private String host;
    @Property(description="IMAP server port", defaultValue="143")
    private int port;
    @Property(required=false, label="Use TLS", description="Use Transport Layer Security (TLS) protocol over IMAP", defaultValue="false")
    private boolean tls;
    @Property(description="IMAP from address")
    private String fromAddress;
    @Property(required=false, label="Enable whitelisting", description="When enabled, only emails to and from whitelisted domains will be processed for remote completion", defaultValue="false")
    private boolean whitelistEnabled;
    @Property(required=false, label="Domain whitelist", description="When enabled, this list contains the whitelisted domains. For example: 'mydomain.com'")
    private List<String> whitelist;
    @Property(password=true, description="Secret for generating email signatures")
    private String secret;
    @Property(required=false, description="IMAP server login ID", category="Basic Authentication")
    private String username;
    @Property(required=false, password=true, description="IMAP server login password", category="Basic Authentication")
    private String password;
    @Property(label="Use OAuth2", description="Use OAuth2 instead of basic authentication.", required=false, category="OAuth2 Authentication")
    private boolean useOAuth2;
    @Property(description="** Required ", required=false, category="OAuth2 Authentication")
    private String accessTokenUrl;
    @Property(description="** Required", required=false, category="OAuth2 Authentication")
    private String clientId;
    @Property(description="** Required", required=false, category="OAuth2 Authentication", password=true)
    private String clientSecret;
    @Property(description="** Required. Clear the access token value when updating the refresh token.", required=false, category="OAuth2 Authentication", password=true)
    private String refreshToken;
    @Property(required=false, category="OAuth2 Authentication", description="Do not enter the value. It is auto-generated. Clear the value when updating the refresh token.", password=true)
    private String accessToken;
    @Property(required=false, label="** If OAuth2 is enabled", category="OAuth2 Authentication")
    private Date expiresAt;

    public ImapServer() {
    }

    public ImapServer(String host, int port, boolean tls, String fromAddress, String username, String password, boolean useOAuth2, String accessTokenUrl, String clientId, String clientSecret, String refreshToken) {
        this.host = host;
        this.port = port;
        this.tls = tls;
        this.fromAddress = fromAddress;
        this.username = username;
        this.password = password;
        this.useOAuth2 = useOAuth2;
        this.accessTokenUrl = accessTokenUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.refreshToken = refreshToken;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isTls() {
        return this.tls;
    }

    public void setTls(boolean tls) {
        this.tls = tls;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isWhitelistEnabled() {
        return this.whitelistEnabled;
    }

    public void setWhitelistEnabled(boolean whitelistEnabled) {
        this.whitelistEnabled = whitelistEnabled;
    }

    public List<String> getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(List<String> whitelist) {
        this.whitelist = whitelist;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean isUseOAuth2() {
        return this.useOAuth2;
    }

    public void setUseOAuth2(boolean useOAuth2) {
        this.useOAuth2 = useOAuth2;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(Date expiresAt) {
        this.expiresAt = expiresAt;
    }

    public String toString() {
        return "ImapServer{host='" + this.getHost() + "', port=" + this.getPort() + ", tls=" + this.isTls() + ", fromAddress='" + this.getFromAddress() + "', whitelistEnabled='" + this.isWhitelistEnabled() + "', whitelist='" + String.valueOf(this.getWhitelist()) + "', useOAuth2='" + this.isUseOAuth2() + "'}";
    }

    public boolean isValid() {
        if (this.isUseOAuth2()) {
            return !Strings.isNullOrEmpty((String)this.getHost()) && !Strings.isNullOrEmpty((String)this.getFromAddress()) && !Strings.isNullOrEmpty((String)this.getSecret()) && !Strings.isNullOrEmpty((String)this.getAccessTokenUrl()) && !Strings.isNullOrEmpty((String)this.getClientId()) && !Strings.isNullOrEmpty((String)this.getClientSecret()) && !Strings.isNullOrEmpty((String)this.getRefreshToken()) && this.getPort() > 0;
        }
        return !Strings.isNullOrEmpty((String)this.getHost()) && !Strings.isNullOrEmpty((String)this.getFromAddress()) && !Strings.isNullOrEmpty((String)this.getSecret()) && !Strings.isNullOrEmpty((String)this.getUsername()) && !Strings.isNullOrEmpty((String)this.getPassword()) && this.getPort() > 0;
    }
}

