/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.xebialabs.xlrelease.plugins.remotecompletion.email.SignatureService;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.TaskAction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletionLink {
    private static final Logger logger = LoggerFactory.getLogger(CompletionLink.class);
    private List<String> to;
    private String subject;
    private String body;
    private TaskAction action;
    private String taskId;
    private Optional<String> signature;

    public CompletionLink(List<String> to, String subject, String body, TaskAction action, String taskId, String fromEmail, SignatureService signatureService) {
        this.to = to;
        this.subject = subject;
        this.body = body;
        this.action = action;
        this.taskId = taskId;
        this.signature = signatureService.createSignature(fromEmail, action.name(), taskId);
        logger.trace("mailto link to: {} subject: {} body: {} action: {} taskid: {} fromEmail: {}", new Object[]{to, subject, body, action, taskId, fromEmail});
    }

    public String getLink() {
        StringBuilder fullbody = new StringBuilder();
        if (this.body != null && !this.body.isEmpty()) {
            fullbody.append(this.body);
            fullbody.append('\n');
            fullbody.append('\n');
        }
        fullbody.append("METADATA (DO NOT MODIFY)");
        fullbody.append('\n');
        fullbody.append("ACTION: ");
        fullbody.append(this.action.name());
        fullbody.append('\n');
        fullbody.append("TASK_ID: ");
        fullbody.append(this.taskId);
        fullbody.append('\n');
        this.signature.ifPresent(sig -> {
            fullbody.append("SIGNATURE: ");
            fullbody.append((String)sig);
            fullbody.append('\n');
        });
        String link = String.format("mailto:%s?subject=%s&body=%s", this.to.stream().map(this::urlEncode).collect(Collectors.joining(",")), this.urlEncode(this.subject), this.urlEncode(fullbody.toString()));
        logger.trace("mailto link (size {})", (Object)link.length());
        return link;
    }

    private String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnsupportedOperationException("UTF-8 not supported");
        }
    }
}

