/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.ImapServer;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.EmailAddressService;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.HandleFeedbackService;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.SignatureService;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.TaskAction;
import com.xebialabs.xlrelease.service.TaskService;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageValidator {
    private static final Logger logger = LoggerFactory.getLogger(MessageValidator.class);
    private static final int BYTES_PER_MEGABYTE = 1000000;
    private static final int SIZE_LIMIT_MEGABYTE = 1;
    private static final Pattern actionPattern = Pattern.compile(".*ACTION:\\s*(COMPLETE|FAIL).*", 32);
    private static final Pattern signaturePattern = Pattern.compile(".*SIGNATURE:\\s*([a-zA-Z0-9/]+).*", 32);
    private static final Pattern taskidPattern = Pattern.compile(".*TASK_ID:\\s*([a-zA-Z0-9/]+).*", 32);
    private HandleFeedbackService handleFeedbackService;
    private EmailAddressService emailAddressService;
    private SignatureService signatureService;
    private TaskService taskService;

    public MessageValidator() {
    }

    @Autowired
    public MessageValidator(HandleFeedbackService handleFeedbackService, EmailAddressService emailAddressService, SignatureService signatureService, TaskService taskService) {
        this.handleFeedbackService = handleFeedbackService;
        this.emailAddressService = emailAddressService;
        this.signatureService = signatureService;
        this.taskService = taskService;
    }

    public String verifyAndGetFromEmail(Message message) throws MessagingException {
        if (message.getFrom() == null || message.getFrom().length < 1) {
            throw new IllegalStateException("From email is not set");
        }
        return ((InternetAddress)message.getFrom()[0]).getAddress();
    }

    public void verifyFromEmailIsNotSameAsImapFromAddress(String fromAddress, String imapFromAddress) {
        if (fromAddress.equalsIgnoreCase(imapFromAddress)) {
            throw new IllegalStateException(String.format("Ignoring email received from same email address as imap server account to avoid endless loops. Imap from address: %s", imapFromAddress));
        }
    }

    public void verifyEmailIsWhitelisted(String fromEmail, ImapServer imapServer) {
        if (!this.emailAddressService.emailIsWhitelisted(fromEmail, imapServer)) {
            throw new IllegalStateException(String.format("Ignoring email from: %s because it could not be matched to any domain set in the domain whitelist IMAP configuration.", fromEmail));
        }
    }

    public void verifyEmailSize(Message msg, String fromEmail) throws MessagingException {
        if (msg.getSize() > 1000000) {
            this.handleFeedbackService.sendMailAndThrowException(String.format("The size of the email sent exceeds the size limit of %s MB.", 1), fromEmail);
        }
    }

    public String verifyAndGetTaskId(String body, String fromEmail) {
        Matcher taskidMatcher = taskidPattern.matcher(body);
        if (!taskidMatcher.matches()) {
            this.handleFeedbackService.sendMailAndThrowException("'TASK_ID' not found or invalid.", fromEmail);
        }
        return taskidMatcher.group(1);
    }

    public TaskAction verifyAndGetAction(String body, String fromEmail) {
        Matcher actionMatcher = actionPattern.matcher(body);
        if (!actionMatcher.matches()) {
            this.handleFeedbackService.sendMailAndThrowException("'ACTION' not found or invalid.", fromEmail);
        }
        return TaskAction.valueOf(actionMatcher.group(1).toUpperCase());
    }

    public String verifyAndGetSignature(String body, String fromEmail) {
        Matcher signatureMatcher = signaturePattern.matcher(body);
        if (!signatureMatcher.matches()) {
            this.handleFeedbackService.sendMailAndThrowException("'SIGNATURE' not found or invalid.", fromEmail);
        }
        return signatureMatcher.group(1);
    }

    public void verifySignature(String body, String fromEmail, TaskAction action, String taskId) {
        String signature = this.verifyAndGetSignature(body, fromEmail);
        Optional<String> signatureCheck = this.signatureService.createSignature(fromEmail, action.name(), taskId);
        if (signatureCheck.isPresent()) {
            String str_signatureCheck = signatureCheck.get();
            logger.info("email ({})", (Object)fromEmail);
            logger.info("signature ({})", (Object)signature);
            logger.info("signatureCheck: ({})", (Object)str_signatureCheck);
            if (!str_signatureCheck.equals(signature)) {
                logger.info("signature not match");
                this.handleFeedbackService.sendMailAndThrowException("The email may have been modified. If email address is case sensitive, enable it from XL Release configurations.", fromEmail);
            }
        }
    }

    public Task verifyAndGetTask(String taskId, String fromEmail) {
        Task task = null;
        try {
            task = this.taskService.findById(taskId);
            if (!task.isInProgress()) {
                this.handleFeedbackService.sendMailAndThrowException(String.format("Task is no longer in progress. Task status is \u2018%s\u2019", task.getStatus()), fromEmail, Optional.of(task));
            }
        }
        catch (NotFoundException ex) {
            this.handleFeedbackService.sendMailAndThrowException("A task with the given ID was not found.", fromEmail);
        }
        return task;
    }

    public Map<String, String> verifyAndGetTaskAssignees(String fromEmail, Task task) {
        Map<String, String> assignees = this.emailAddressService.getEmailAddressesFromTask(task);
        if (!assignees.containsKey(this.signatureService.correctCase(fromEmail))) {
            this.handleFeedbackService.sendMailAndThrowException(String.format("Email address \u2018%s\u2019 does not match a user who is assigned to the task.", fromEmail), fromEmail, Optional.of(task));
        }
        return assignees;
    }

    public String correctCase(String fromEmail) {
        return this.signatureService.correctCase(fromEmail);
    }
}

