/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.xebialabs.xlrelease.plugins.remotecompletion.email.HandleFeedbackService;
import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageReader {
    private static final Logger logger = LoggerFactory.getLogger(MessageReader.class);
    private final HandleFeedbackService handleFeedbackService;

    @Autowired
    public MessageReader(HandleFeedbackService handleFeedbackService) {
        this.handleFeedbackService = handleFeedbackService;
    }

    public String getEmailBody(Message message, String fromEmail) {
        StringBuilder result = new StringBuilder();
        try {
            result.append(this.getParts((Part)message, fromEmail));
        }
        catch (Exception ex) {
            logger.error("Error while reading body", (Throwable)ex);
            this.handleFeedbackService.sendMailAndThrowException("Unsupported mail format received.", fromEmail);
        }
        logger.trace("Message body read. data: [{}]", (Object)result);
        return result.toString();
    }

    private String getParts(Part part, String fromEmail) throws IOException, MessagingException {
        StringBuilder result = new StringBuilder();
        Object contentObject = part.getContent();
        if (contentObject instanceof Multipart) {
            Multipart content = (Multipart)contentObject;
            int count = content.getCount();
            logger.trace("Reading message. Content type: {} number of parts: {}", (Object)content.getContentType(), (Object)count);
            for (int i = 0; i < count; ++i) {
                BodyPart innerPart = content.getBodyPart(i);
                if (innerPart.isMimeType("multipart/alternative")) {
                    logger.trace("Recursively reading body part.");
                    result.append(this.getParts((Part)innerPart, fromEmail));
                    continue;
                }
                if (innerPart.getDisposition() != null && innerPart.getDisposition().equals("attachment")) {
                    logger.trace("Skipping attachment");
                    continue;
                }
                if (innerPart.isMimeType("text/plain") || innerPart.isMimeType("text/html")) {
                    logger.trace("Appending part to read body. Content type: {} data: [{}]", (Object)innerPart.getContentType(), innerPart.getContent());
                    result.append(innerPart.getContent());
                    continue;
                }
                logger.trace("Ignoring unsupported body part with content type: {}", (Object)innerPart.getContentType());
            }
        } else if (contentObject instanceof String) {
            result.append(contentObject);
        } else {
            this.handleFeedbackService.sendMailAndThrowException("Unsupported mail format received.", fromEmail);
            logger.trace("Unsupported message with content type: {}", (Object)part.getContentType());
        }
        return result.toString();
    }
}

