/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.CiUtils;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.ImapServer;
import com.xebialabs.xlrelease.plugins.remotecompletion.util.FunctionalUtils;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.mail.MessagingException;
import javax.mail.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmailStore {
    private static final Logger logger = LoggerFactory.getLogger(EmailStore.class);
    private static final int MAIL_TIMEOUT = 30000;
    private static final String MAIL_IMAP_CONNECTION_TIMEOUT = "mail.imap.connectiontimeout";
    private static final String MAIL_IMAP_TIMEOUT = "mail.imap.timeout";
    private Optional<IMAPStore> imapStore = Optional.empty();
    protected ImapServer imapServer;
    private Optional<IMAPFolder> inbox = Optional.empty();

    public EmailStore(ImapServer imapServer) {
        this.imapServer = imapServer;
        this.initializeStore(imapServer, "imap");
        this.initializeInbox(false);
    }

    @PreDestroy
    public void close() {
        logger.debug("Closing the IMAPStore");
        this.imapStore.ifPresent(store -> {
            try {
                store.close();
            }
            catch (MessagingException e) {
                logger.warn("Encountered an exception while closing IMAPStore", (Throwable)e);
            }
        });
    }

    @Autowired
    public EmailStore(ConfigurationRepository configurationRepository) {
        this.imapServer = CiUtils.getImapServer(configurationRepository).orElse(new ImapServer());
        if (!this.imapServer.isValid()) {
            logger.debug("Could not find a valid mail server configuration. Skipping mail synchronisation.");
            return;
        }
        logger.debug("Mail server configuration found. Started mail server synchronisation. {}", (Object)this.imapServer);
        this.initializeStore(this.imapServer, "imap");
        this.initializeInbox(true);
    }

    public boolean isWhitelistEnabled() {
        return this.imapServer.isWhitelistEnabled();
    }

    public List<String> getWhitelist() {
        return this.imapServer.getWhitelist();
    }

    public boolean hasSortCapability() {
        try {
            return this.imapStore.get().hasCapability("SORT*");
        }
        catch (MessagingException e) {
            logger.error("Encountered an exception while checking sort capability : " + FunctionalUtils.getNestedExceptionsMessagesFunction.apply(e));
            return false;
        }
    }

    public String getFromAddress() {
        return this.imapServer.getFromAddress();
    }

    private void initializeStore(ImapServer server, String protocol) {
        try {
            Properties props = this.getImapProperties(server);
            Session session = Session.getInstance((Properties)props);
            this.imapStore = Optional.ofNullable((IMAPStore)session.getStore(protocol));
        }
        catch (MessagingException e) {
            logger.warn("Unable to initialize email store : " + FunctionalUtils.getNestedExceptionsMessagesFunction.apply(e));
        }
    }

    private void initializeInbox(boolean decryptPassword) {
        try {
            String password = decryptPassword ? PasswordEncrypter.getInstance().decrypt(this.imapServer.getPassword()) : this.imapServer.getPassword();
            this.imapStore.get().connect(this.imapServer.getHost(), this.imapServer.getPort(), this.imapServer.getUsername(), password);
            IMAPFolder inbox = (IMAPFolder)this.imapStore.get().getFolder("INBOX");
            inbox.open(2);
            this.inbox = Optional.of(inbox);
        }
        catch (MessagingException e) {
            logger.warn("Unable to initialize email inbox : " + FunctionalUtils.getNestedExceptionsMessagesFunction.apply(e));
        }
    }

    public Optional<IMAPFolder> getInbox() {
        if (!this.inbox.isPresent() && this.imapStore.isPresent()) {
            this.initializeInbox(true);
        }
        this.inbox.ifPresent(folder -> {
            try {
                if (!folder.isOpen()) {
                    folder.open(2);
                }
            }
            catch (MessagingException e) {
                logger.error("Unable to open inbox for read/write mode", (Throwable)e);
            }
        });
        return this.inbox;
    }

    private Properties getImapProperties(ImapServer imapServer) {
        Properties props = System.getProperties();
        String mailTimeout = String.valueOf(30000);
        if (!props.containsKey(MAIL_IMAP_CONNECTION_TIMEOUT)) {
            props.setProperty(MAIL_IMAP_CONNECTION_TIMEOUT, mailTimeout);
        }
        if (!props.containsKey(MAIL_IMAP_TIMEOUT)) {
            props.setProperty(MAIL_IMAP_TIMEOUT, mailTimeout);
        }
        if (imapServer.isTls()) {
            props.setProperty("mail.imap.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.imap.socketFactory.fallback", "false");
        } else {
            props.setProperty("mail.imap.socketFactory.class", "javax.net.SocketFactory");
        }
        logger.trace("Connection properties passed to javamail: {}", props.entrySet().stream().filter(e -> e.getKey().toString().startsWith("mail")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return props;
    }
}

