/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.ci;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.Configuration;
import java.util.List;

@Metadata(root=Metadata.ConfigurationItemRoot.CONFIGURATION, label="Remote Completion: IMAP Server", versioned=false)
public class ImapServer
extends Configuration {
    @Property(hidden=true, defaultValue="remotecompletion/EmailConnectionCheck.py")
    private String scriptLocation;
    @Property(description="IMAP server host")
    private String host;
    @Property(description="IMAP server port", defaultValue="143")
    private int port;
    @Property(required=false, label="Use TLS", description="Use Transport Layer Security (TLS) protocol over IMAP", defaultValue="false")
    private boolean tls;
    @Property(description="IMAP from address")
    private String fromAddress;
    @Property(description="IMAP server login ID")
    private String username;
    @Property(password=true, description="IMAP server login password")
    private String password;
    @Property(required=false, label="Enable whitelisting", description="When enabled, only emails to and from whitelisted domains will be processed for remote completion", defaultValue="false")
    private boolean whitelistEnabled;
    @Property(required=false, label="Domain whitelist", description="When enabled, this list contains the whitelisted domains. For example: 'mydomain.com'")
    private List<String> whitelist;
    @Property(password=true, description="Secret for generating email signatures")
    private String secret;

    public ImapServer() {
    }

    public ImapServer(String host, int port, boolean tls, String username, String password) {
        this.host = host;
        this.port = port;
        this.tls = tls;
        this.username = username;
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isTls() {
        return this.tls;
    }

    public void setTls(boolean tls) {
        this.tls = tls;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isWhitelistEnabled() {
        return this.whitelistEnabled;
    }

    public void setWhitelistEnabled(boolean whitelistEnabled) {
        this.whitelistEnabled = whitelistEnabled;
    }

    public List<String> getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(List<String> whitelist) {
        this.whitelist = whitelist;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String toString() {
        return "ImapServer{host='" + this.getHost() + "', port=" + this.getPort() + ", tls=" + this.isTls() + ", fromAddress='" + this.getFromAddress() + "', username='" + this.getUsername() + "', whitelistEnabled='" + this.isWhitelistEnabled() + "', whitelist='" + this.getWhitelist() + "'}";
    }

    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.getHost()) && !Strings.isNullOrEmpty((String)this.getUsername()) && !Strings.isNullOrEmpty((String)this.getPassword()) && !Strings.isNullOrEmpty((String)this.getFromAddress()) && !Strings.isNullOrEmpty((String)this.getSecret()) && this.getPort() > 0;
    }
}

