/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.notifications.email.Email;
import com.xebialabs.xlrelease.notifications.email.EmailSender;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.CiUtils;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.ImapServer;
import com.xebialabs.xlrelease.plugins.remotecompletion.context.EmailContext;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.EmailAddressService;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.EmailBuilder;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.SignatureService;
import com.xebialabs.xlrelease.plugins.remotecompletion.util.FunctionalUtils;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Option;

@Service
public class RemoteCompletionEmailService {
    private static final String EMAIL_TEMPLATE = "remote-completion-task-template.mustache";
    static final String ERROR_NO_IMAP_SERVER = "Imap server is incorrectly configured. Check if all the required fields are set.";
    static final String ERROR_NO_OWNER_AND_TEAM_EMAIL = "Task owner's email address and team members email addresses are not configured or not whitelisted";
    private static final Logger logger = LoggerFactory.getLogger(RemoteCompletionEmailService.class);
    private final ConfigurationRepository configurationRepository;
    private final EmailContext emailContext;
    private final EmailSender emailSender;
    private final ReleaseActorService releaseActorService;
    private final SignatureService signatureService;
    private final EmailAddressService emailAddressService;

    @Autowired
    public RemoteCompletionEmailService(ConfigurationRepository configurationRepository, EmailAddressService emailAddressService, EmailContext emailContext, EmailSender emailSender, ReleaseActorService releaseActorService, SignatureService signatureService) {
        this.configurationRepository = configurationRepository;
        this.emailAddressService = emailAddressService;
        this.emailContext = emailContext;
        this.emailSender = emailSender;
        this.releaseActorService = releaseActorService;
        this.signatureService = signatureService;
    }

    public void execute(Task task) {
        Optional<ImapServer> imapServerOptional = CiUtils.getImapServer(this.configurationRepository);
        boolean isImapServerConfigured = imapServerOptional.map(ImapServer::isValid).orElse(false);
        if (!isImapServerConfigured) {
            this.releaseActorService.failTaskAsync(task.getId(), FailureReasons.NOTIFICATION_TASK_FAILED.format(new Object[]{ERROR_NO_IMAP_SERVER}), User.SYSTEM, Option.empty());
            return;
        }
        Map<String, String> emailToUserMap = this.emailAddressService.getEmailAddressesFromTask(task);
        Collection nonWhitelistedUsers = emailToUserMap.entrySet().stream().filter(emailAddress -> !this.emailAddressService.emailIsWhitelisted((String)emailAddress.getKey(), (ImapServer)((Object)((Object)imapServerOptional.get()))) && !((String)emailAddress.getKey()).isEmpty()).map(Map.Entry::getValue).collect(Collectors.toList());
        Collection whitelistedEmails = emailToUserMap.keySet().stream().filter(emailAddress -> this.emailAddressService.emailIsWhitelisted((String)emailAddress, (ImapServer)((Object)((Object)imapServerOptional.get()))) && !emailAddress.isEmpty()).collect(Collectors.toList());
        Collection usersWithoutEmailAddress = emailToUserMap.entrySet().stream().filter(emailAddress -> ((String)emailAddress.getKey()).isEmpty()).map(Map.Entry::getValue).collect(Collectors.toList());
        if (whitelistedEmails.isEmpty()) {
            this.releaseActorService.failTaskAsync(task.getId(), FailureReasons.NOTIFICATION_TASK_FAILED.format(new Object[]{ERROR_NO_OWNER_AND_TEAM_EMAIL}), User.SYSTEM, Option.empty());
            return;
        }
        imapServerOptional.map(ImapServer::getFromAddress).ifPresent(completionEmail -> {
            Map<String, Object> context = this.emailContext.buildContext(task);
            EmailBuilder emailBuilder = new EmailBuilder(this.signatureService);
            Set<Email> emails = emailBuilder.buildEmails(task, context, whitelistedEmails, (String)completionEmail, EMAIL_TEMPLATE);
            this.sendEmails(task, emails, nonWhitelistedUsers, emailToUserMap, usersWithoutEmailAddress);
        });
    }

    private void sendEmails(Task task, Collection<Email> emails, Collection<String> nonWhitelistedEmails, Map<String, String> emailToUserMap, Collection<String> usersWithoutEmailAddress) {
        if (logger.isDebugEnabled()) {
            String emailAddressesToSent = emails.stream().flatMap(FunctionalUtils.emailRecipientMapper).collect(Collectors.joining(", "));
            logger.debug("Trying to send emails to addresses {}", (Object)emailAddressesToSent);
        }
        ArrayList successUsers = new ArrayList();
        ArrayList failedUsers = new ArrayList();
        ArrayList exceptionMessages = new ArrayList();
        CompletableFuture.allOf((CompletableFuture[])emails.stream().map(email -> this.emailSender.scheduleEmail(email).handle((res, ex) -> {
            if (ex != null) {
                failedUsers.addAll(FunctionalUtils.getUserFromEmailBiFunction.apply((Email)email, emailToUserMap));
                exceptionMessages.add(FunctionalUtils.getNestedExceptionsMessagesFunction.apply((Throwable)ex));
            } else {
                successUsers.addAll(FunctionalUtils.getUserFromEmailBiFunction.apply((Email)email, emailToUserMap));
            }
            return null;
        })).toArray(CompletableFuture[]::new)).thenRun(() -> {
            String notificationFailedMsg = this.getNotificationFailedMsg(usersWithoutEmailAddress, nonWhitelistedEmails, failedUsers, exceptionMessages);
            if (successUsers.isEmpty()) {
                logger.warn("Failed to send remote approval emails for task: {}. {}", (Object)task.getTitle(), (Object)notificationFailedMsg);
                this.releaseActorService.failTaskAsync(task.getId(), notificationFailedMsg, User.SYSTEM, Option.empty());
            } else {
                StringBuilder notification = new StringBuilder("Email sent to user(s): ");
                notification.append(this.formatAndDistinctSortJoinWithComma(successUsers, "%s"));
                if (!notificationFailedMsg.isEmpty()) {
                    notification.append(".\n");
                    notification.append(notificationFailedMsg);
                }
                logger.info("Remote completion requested for task: {}. {}", (Object)task.getTitle(), (Object)notification);
                this.releaseActorService.addCommentToTask(task.getId(), notification.toString());
            }
        });
    }

    private String formatAndDistinctSortJoinWithComma(Collection<String> items, String formatter) {
        return items.stream().distinct().sorted().map(s -> String.format(formatter, s)).collect(Collectors.joining(", "));
    }

    private String getNotificationFailedMsg(Collection<String> usersWithoutEmailAddress, Collection<String> nonWhitelistedEmails, Collection<String> failedUsers, Collection<String> exceptionMessages) {
        StringBuilder notificationFailedMsg = new StringBuilder();
        if (!usersWithoutEmailAddress.isEmpty()) {
            String emptyEmailAddressFailedMsg = String.format("No email sent to %s, reason: 'No email address configured'. ", this.formatAndDistinctSortJoinWithComma(usersWithoutEmailAddress, "%s"));
            notificationFailedMsg.append(emptyEmailAddressFailedMsg);
        }
        if (!nonWhitelistedEmails.isEmpty()) {
            String notWhitelistedFailedMsg = String.format("No email sent to %s, reason: 'Domain not whitelisted'. ", this.formatAndDistinctSortJoinWithComma(nonWhitelistedEmails, "%s"));
            notificationFailedMsg.append(notWhitelistedFailedMsg);
        }
        if (!failedUsers.isEmpty()) {
            notificationFailedMsg.append(String.format("Sending email failed for user(s): %s, reason: %s", this.formatAndDistinctSortJoinWithComma(failedUsers, "%s"), this.formatAndDistinctSortJoinWithComma(exceptionMessages, "'%s'")));
        }
        return notificationFailedMsg.toString();
    }
}

