'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var ResourceUsageTileController = function () {
    function ResourceUsageTileController($scope, ReleasesService, TasksService, FlagService) {
        _classCallCheck(this, ResourceUsageTileController);

        if ($scope.xlrDashboard) {
            // summary page
            this._release = $scope.xlrDashboard.release;
        } else {
            // details page
            this._release = $scope.xlrTileDetailsCtrl.release;
        }

        this._UNASSIGNED_USER = null;

        this.$scope = $scope;
        this.ReleasesService = ReleasesService;
        this.TasksService = TasksService;
        this.FlagService = FlagService;

        this._showOwners = true;
        this._showTeams = false;

        this._colorPool = ['#7E827A', '#4AA0C8', '#7E827A', '#7E8AA2', '#45BF55', '#7FB2F0', '#35203B', '#644D52', '#8E2800', '#B85C5A', '#FF8598', '#FF6F69', '#F77A52', '#FCD364', '#FFE11A', '#FFA500'];

        this._chartOptions = {
            topTitleText: function topTitleText(data) {
                return _.sum(data, function (o) {
                    return o.y;
                });
            },
            bottomTitleText: "tasks",
            series: function series(data) {
                return [{
                    name: 'Tasks',
                    data: data
                }];
            },
            showLegend: false,
            donutThickness: '90%'
        };
        this._chartData = [];
        this._flattenedTasks = [];

        this._generateChartData();
    }

    _createClass(ResourceUsageTileController, [{
        key: '_generateChartData',
        value: function _generateChartData() {
            var _this = this;

            this._flattenedTasks = this.ReleasesService.getLeafTasks(this._release);
            this._ownersTasks = this._groupTasksByProperty(this.flattenedTasks, 'owner.username');
            this._teamsTasks = this._groupTasksByProperty(this.flattenedTasks, 'team', function (team) {
                return team;
            });

            if (this._showOwners && !this._showTeams) {
                this._detailGroupedTasks = this._ownersTasks;
            } else {
                this._detailGroupedTasks = this._teamsTasks;
            }
            var graphElements = _.map(this._detailGroupedTasks, function (data) {
                return {
                    y: data.tasks.length,
                    name: _this.decorateOwnerName(data.owner),
                    color: _this._getColor(),
                    originalName: data.owner ? data.owner.username : null
                };
            });
            this._chartData = _.sortBy(graphElements, 'originalName').reverse();
        }
    }, {
        key: '_groupTasksByProperty',
        value: function _groupTasksByProperty(tasks, propertyName) {
            var groupedTasks = _.chain(tasks).groupBy(propertyName).value();
            var groupKeys = Object.keys(groupedTasks);
            var collectionOfTasksGroupedByProperty = [];

            var groupKeysLength = groupKeys.length;
            for (var i = 0; i < groupKeysLength; i++) {
                var key = groupKeys[i];
                collectionOfTasksGroupedByProperty.push({
                    tasks: groupedTasks[key],
                    owner: groupedTasks[key][0].owner,
                    team: groupedTasks[key][0].team
                });
            }

            return _.sortBy(collectionOfTasksGroupedByProperty, propertyName).reverse();
        }
    }, {
        key: 'decorateOwnerName',
        value: function decorateOwnerName(owner) {
            if (!owner) {
                return 'Unassigned';
            }
            if (owner.fullName) {
                return owner.fullName;
            }
            return owner.username;
        }
    }, {
        key: 'decorateTeamName',
        value: function decorateTeamName(team) {
            return team || 'Unassigned';
        }
    }, {
        key: 'selectOwners',
        value: function selectOwners() {
            this._showOwners = true;
            this._showTeams = false;
            this._detailGroupedTasks = this._ownersTasks;
        }
    }, {
        key: 'selectTeams',
        value: function selectTeams() {
            this._showOwners = false;
            this._showTeams = true;
            this._detailGroupedTasks = this._teamsTasks;
        }
    }, {
        key: 'isCurrentTask',
        value: function isCurrentTask(task) {
            return this.TasksService.isTaskInProgress(task) || this.TasksService.isTaskFailed(task) || this.TasksService.isTaskWaitingForInput(task) || this.TasksService.isTaskFailing(task);
        }
    }, {
        key: 'isCurrentTeamTask',
        value: function isCurrentTeamTask(task, team) {
            return this.TasksService.isAssignedToTeam(task, team) && this.isCurrentTask(task);
        }
    }, {
        key: 'isAssignedToTeam',
        value: function isAssignedToTeam(task, team) {
            return this.TasksService.isAssignedToTeam(task, team);
        }
    }, {
        key: 'isAssignedToUser',
        value: function isAssignedToUser(task, user) {
            return this.TasksService.isAssignedToUser(task, user) || !this.TasksService.hasOwner(task) && user === this._UNASSIGNED_USER;
        }
    }, {
        key: 'isCurrentTaskForUser',
        value: function isCurrentTaskForUser(task, user) {
            return this.isAssignedToUser(task, user) && this.isCurrentTask(task);
        }
    }, {
        key: 'isTaskFlagged',
        value: function isTaskFlagged(task) {
            return this.FlagService.isTaskFlagged(task);
        }
    }, {
        key: 'isTaskDelayed',
        value: function isTaskDelayed(task) {
            return this.TasksService.isTaskDelayed(task);
        }
    }, {
        key: '_getColor',
        value: function _getColor() {
            return this._colorPool.pop();
        }
    }, {
        key: 'chartOptions',
        get: function get() {
            return this._chartOptions;
        }
    }, {
        key: 'flattenedTasks',
        get: function get() {
            return this._flattenedTasks;
        }
    }, {
        key: 'detailGroupedTasks',
        get: function get() {
            return this._detailGroupedTasks;
        }
    }, {
        key: 'chartData',
        get: function get() {
            return this._chartData;
        }
    }, {
        key: 'showOwners',
        get: function get() {
            return this._showOwners;
        }
    }, {
        key: 'showTeams',
        get: function get() {
            return this._showTeams;
        }
    }]);

    return ResourceUsageTileController;
}();

ResourceUsageTileController.$inject = ['$scope', 'ReleasesService', 'TasksService', 'FlagService'];

angular.module('xlrelease').controller('summary.ResourceUsageTileController', ResourceUsageTileController);