'use strict';

(function () {

    var ReleaseSummaryPageController = function ReleaseSummaryPageController($scope, ReleasesService, TasksService) {
        var vm = this;
        var xlrDashboard = $scope.xlrDashboard;
        vm.release = xlrDashboard.release;
        vm.isReleaseInProgress = ReleasesService.isReleaseInProgress;
        vm.isReleaseFailing = ReleasesService.isReleaseFailing;
        vm.isReleasePaused = ReleasesService.isReleasePaused;
        vm.isReleaseFailed = ReleasesService.isReleaseFailed;
        vm.isReleasePlanned = ReleasesService.isReleasePlanned;
        vm.isReleaseAborted = ReleasesService.isReleaseAborted;
        vm.isReleaseCompleted = ReleasesService.isReleaseCompleted;
        vm.hasCompletedStatus = ReleasesService.hasCompletedStatus;
        vm.isReleaseArchived = ReleasesService.isReleaseArchived;

        vm.flattenedTasks = ReleasesService.getLeafTasks(vm.release);
        vm.numberOfCompletedTasks = _.filter(vm.flattenedTasks, TasksService.isTaskReadOnly).length;
    };

    ReleaseSummaryPageController.$inject = ['$scope', 'ReleasesService', 'TasksService'];

    angular.module('xlrelease').controller('summary.ReleaseSummaryPageController', ReleaseSummaryPageController);
})();