'use strict';

(function () {

    var ReleaseProgressTileViewController = function ReleaseProgressTileViewController($scope, ReleasesService, TasksService, Planner) {
        var vm = this;
        vm.isReleaseCompleted = isReleaseCompleted;
        vm.refresh = refresh;
        vm.release = $scope.release;
        vm.getStatus = getStatus;
        vm.calculateDelay = calculateDelay;

        vm.chartOptions = {
            topTitleText: function topTitleText(data) {
                return data.completed + "/" + (data.completed + data.planned);
            },
            bottomTitleText: "tasks",
            legend: {
                borderRadius: 0
            },
            series: function series(data) {
                return [{
                    name: 'Tasks',
                    data: [{
                        y: data.completed,
                        name: "Completed",
                        color: "#5DAE3F"
                    }, {
                        y: data.planned,
                        name: "Planned",
                        color: "#DDD"
                    }]
                }];
            },
            showLegend: true,
            donutThickness: '90%'
        };

        ///

        refresh();

        function refresh() {
            var flattenedTasks = ReleasesService.getLeafTasks(vm.release);
            var completedTasks = calculateCompletedTasks(flattenedTasks);
            vm.chartData = {
                completed: completedTasks.length,
                planned: flattenedTasks.length - completedTasks.length
            };
            vm.progress = calculateProgress(completedTasks.length, flattenedTasks.length);
            vm.estimatedEndDate = calculateEstimatedEndDate(vm.release);
        }

        function isReleaseCompleted() {
            return ReleasesService.isReleaseCompleted(vm.release);
        }

        function calculateCompletedTasks(tasks) {
            return _.filter(tasks, TasksService.isTaskReadOnly);
        }

        function calculateProgress(completed, total) {
            var progress = 0;
            if (angular.isNumber(completed) && angular.isNumber(total) && total != 0) {
                progress = completed / total * 100;
            }
            return progress;
        }

        function calculateEstimatedEndDate(release) {
            Planner.setRelease(release);
            Planner.setReleaseTree(release.tree);
            var plan = Planner.makePlan(false);
            return plan.plannedEndDate;
        }

        function calculateDelay() {
            return moment.duration(vm.estimatedEndDate.diff(moment(vm.release.dueDate)));
        }

        function getStatus() {
            var status = "";
            if (isAborted()) {
                status = "ABORTED";
            } else if (isOnTime()) {
                status = "ON_TIME";
            } else {
                status = "DELAYED";
            }
            return status;
        }

        function isOnTime() {
            return !vm.estimatedEndDate.isAfter(moment(vm.release.dueDate));
        }

        function isAborted() {
            return ReleasesService.isReleaseAborted(vm.release);
        }
    };

    ReleaseProgressTileViewController.$inject = ['$scope', 'ReleasesService', 'TasksService', 'Planner'];

    angular.module('xlrelease').controller('summary.ReleaseProgressTileViewController', ReleaseProgressTileViewController);
})();