'use strict';

(function () {

    var ReleaseAlertsTileViewController = function ReleaseAlertsTileViewController($scope, ReleasesService, ReleaseAlerts) {
        var vm = this;
        vm.isReleaseCompleted = isReleaseCompleted;
        vm.refresh = refresh;
        vm.conflicts = [];
        vm.flaggedItems = [];
        vm.delayedTasks = [];
        vm.release = $scope.release;

        refresh();

        ///

        function getNumberOfAlerts() {
            return vm.conflicts.length + vm.delayedTasks.length + vm.flaggedItems.length;
        }

        function refresh() {
            var flattenedTasks = ReleasesService.getLeafTasks(vm.release);
            return ReleasesService.getReleaseDependencies(vm.release.id).then(function (response) {
                var outgoingDependencies = response.data.outgoingDependencies;
                vm.conflicts = ReleaseAlerts.computeConflicts(outgoingDependencies);
                vm.flaggedItems = ReleaseAlerts.computeFlaggedItems(vm.release, flattenedTasks);
                vm.delayedTasks = ReleaseAlerts.computeDelayedTasks(flattenedTasks);
                vm.numberOfAlerts = getNumberOfAlerts();
            });
        }

        function isReleaseCompleted() {
            return ReleasesService.isReleaseCompleted(vm.release);
        }
    };

    ReleaseAlertsTileViewController.$inject = ['$scope', 'ReleasesService', 'ReleaseAlerts'];

    angular.module('xlrelease').controller('summary.ReleaseAlertsTileViewController', ReleaseAlertsTileViewController);
})();