'use strict';

(function () {

    var TimelineTileControllerInjects = ['$scope', 'TasksService', 'ReleasesService', 'Timeline', 'DependenciesService'];
    var TimelineTileController = function TimelineTileController($scope, TasksService, ReleasesService, Timeline, DependenciesService) {

        var incomingDependenciesArray = [];
        var outgoingDependenciesArray = [];
        var vm = this;
        vm.loading = true;

        if ($scope.xlrDashboard) {
            // summary page
            vm.release = $scope.xlrDashboard.release;
            vm.isDetailsView = false;
        } else {
            // details page
            vm.release = $scope.xlrTileDetailsCtrl.release;
            vm.isDetailsView = true;
        }

        vm.currentPhase = vm.release.currentPhase;
        vm.currentPhaseTasks = getPhaseTasks(vm.release.phases);
        vm.containsOutgoingDependencies = false;
        vm.containsIncomingDependencies = false;

        vm.timelineContainer = {
            timeline: null,
            incomingDependencies: [],
            outgoingDependencies: []
        };

        function init() {
            ReleasesService.getReleaseDependencies(vm.release.id).then(function (result) {
                return result.data;
            }).then(applyToVm).then(initializeTimeline).then(function (data) {
                vm.timelineData = {
                    timeline: data,
                    incomingDependencies: incomingDependenciesArray,
                    outgoingDependencies: outgoingDependenciesArray
                };
                vm.loading = false;
            });
        }

        init();

        function applyToVm(releaseDependencies) {
            var outgoingDependencies = releaseDependencies.outgoingDependencies;
            var incomingDependencies = releaseDependencies.incomingDependencies;
            var outgoingReleases = _.pluck(outgoingDependencies, 'release');
            var incomingReleases = _.pluck(incomingDependencies, 'release');
            vm.releaseDependencies = releaseDependencies;
            incomingDependenciesArray = getIncomingDependencies(incomingReleases);
            outgoingDependenciesArray = getOutgoingDependencies(outgoingReleases);
            if (vm.releaseDependencies.outgoingDependencies.length > 0) {
                vm.containsOutgoingDependencies = true;
            }
            if (vm.releaseDependencies.incomingDependencies.length > 0) {
                vm.containsIncomingDependencies = true;
            }
            return _.union(outgoingReleases, [vm.release], incomingReleases);
        }

        function initializeTimeline(timelineReleases) {
            return DependenciesService.getReleaseTree(vm.release).then(function (releaseTree) {
                return Timeline.init(vm.release, timelineReleases, releaseTree);
            });
        }

        function getPhaseTasks(phases) {
            var phaseFounded = _.find(phases, function (phase) {
                return phase.status === "IN_PROGRESS" || phase.status === 'FAILED';
            });
            return phaseFounded ? phaseFounded.tasks : [];
        }

        function getOutgoingDependencies(outgoingReleases) {
            return _.map(outgoingReleases, function (dep) {
                return {
                    id: dep.id,
                    title: dep.title,
                    startDate: moment(dep.startDate),
                    endDate: moment(dep.endDate),
                    estimatedStartDate: moment(dep.scheduledStartDate),
                    estimatedEndDate: moment(dep.dueDate)
                };
            });
        }

        function getIncomingDependencies(incomingReleases) {
            return _.map(incomingReleases, function (dep) {
                return {
                    id: dep.id,
                    title: dep.title,
                    startDate: moment(dep.startDate),
                    endDate: moment(dep.endDate),
                    estimatedStartDate: moment(dep.scheduledStartDate),
                    estimatedEndDate: moment(dep.dueDate)
                };
            });
        }
    };

    TimelineTileController.$inject = TimelineTileControllerInjects;

    angular.module('xlrelease').controller('summary.timelineTileController', TimelineTileController);
})();