'use strict';

(function () {

    var ReleaseSummaryTileViewController = function ReleaseSummaryTileViewController($scope, DateService) {
        var vm = this;
        var release = $scope.release;
        vm.isOverdue = DateService.isOverdue;

        refresh();

        function refresh() {
            vm.releaseCurrentPhase = getActivePhase(release);
            vm.startDate = getStartDate(release);
            vm.dueDate = getDueDate(release);
            vm.releaseDuration = getDuration(release);
            vm.owner = release.owner;
        }

        function getActivePhase(release) {
            var activePhase = _.filter(release.phases, { 'active': true });
            if (activePhase && activePhase.length > 0) {
                return activePhase[0].title;
            }
            return "Not started";
        }

        function getOwner(release) {
            var owner = release.owner;
            if (_.has(release, 'owner.fullName')) {
                return release.owner.fullName;
            } else if (_.has(release, 'owner.username')) {
                return release.owner.username;
            } else {
                return '';
            }
        }

        function getStartDate(release) {
            return DateService.getStartOrScheduledDate(release);
        }

        function getDueDate(release) {
            return release.dueDate;
        }

        function getDuration(release) {
            var start = DateService.getStartOrScheduledDate(release);
            var end = release.dueDate;

            if (start && end && end >= start) {
                return end - start;
            }
            return undefined;
        }
    };

    ReleaseSummaryTileViewController.$inject = ['$scope', 'DateService'];

    angular.module('xlrelease').controller('summary.ReleaseSummaryTileViewController', ReleaseSummaryTileViewController);
})();