'use strict';

(function () {
    angular.module('xlrelease').factory('XlrTileHelper', ['Window', function (Window) {

        var adjustGridHeight = function adjustGridHeight() {
            var container = angular.element(".grid-container");
            container.height(Window.height() - container.offset().top - 35);
        };

        var countTasksByStatus = function countTasksByStatus(tasks, counts) {
            counts = {
                completed: 0,
                progress: 0,
                planned: 0,
                failed: 0,
                skipped: 0
            };

            _.forEach(tasks, function (build) {
                counts[build.taskStatusCategory] += 1;
            });
            return counts;
        };

        var getCategoryByTaskStatus = function getCategoryByTaskStatus(taskStatus) {
            var taskStatusToTileStatus = {
                COMPLETED: 'completed',
                IN_PROGRESS: 'progress',
                PLANNED: 'planned',
                PENDING: 'planned',
                PRECONDITION_IN_PROGRESS: 'progress',
                WAITING_FOR_INPUT: 'progress',
                FAILED: 'failed',
                SKIPPED: 'skipped',
                COMPLETED_IN_ADVANCE: 'success',
                SKIPPED_IN_ADVANCE: 'skipped',
                ABORTED: 'skipped'
            };
            return taskStatusToTileStatus[taskStatus];
        };

        var getGridOptions = function getGridOptions(data, columnDefs) {
            return {
                enableSorting: false,
                enableRowHeaderSelection: false,
                multiSelect: false,
                data: data,
                enableFiltering: true,
                enableColumnResize: true,
                columnDefs: columnDefs,
                onRegisterApi: adjustGridHeight
            };
        };

        var getChartOptions = function getChartOptions(options) {
            return {
                topTitleText: function topTitleText() {
                    return "" + options.total;
                },
                bottomTitleText: function bottomTitleText() {
                    return options.total == 1 ? options.label.toLowerCase() : options.label.toLowerCase() + 's';
                },
                series: function series(data) {
                    return [{
                        name: options.label + 's',
                        data: [{
                            y: data.completed,
                            name: 'Completed',
                            color: '#499D2B'
                        }, {
                            y: data.progress,
                            name: 'In progress',
                            color: '#40ADE6'
                        }, {
                            y: data.planned,
                            name: 'Planned',
                            color: '#DDD'
                        }, {
                            y: data.failed,
                            name: 'Failed',
                            color: '#9A2C2E'
                        }, {
                            y: data.skipped,
                            name: 'Skipped',
                            color: '#C3C3C3'
                        }]
                    }];
                },
                showLegend: false,
                donutThickness: '80%'
            };
        };

        return {
            adjustGridHeight: adjustGridHeight,
            countTasksByStatus: countTasksByStatus,
            getCategoryByTaskStatus: getCategoryByTaskStatus,
            getGridOptions: getGridOptions,
            getChartOptions: getChartOptions
        };
    }]);
})();