/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.relationships.service;

import com.xebialabs.xlrelease.api.v1.ReleaseApi;
import com.xebialabs.xlrelease.api.v1.TemplateApi;
import com.xebialabs.xlrelease.relationships.graph.Graph;
import com.xebialabs.xlrelease.relationships.graph.RelationshipsResolver;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.risk.api.v1.RiskApi;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/relationships")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class RelationshipsService {
    private static final Logger logger = LoggerFactory.getLogger(RelationshipsService.class);
    private RelationshipsResolver resolver;

    @Autowired
    public RelationshipsService(ReleaseApi releaseApi, TemplateApi templateApi, RiskApi riskApi, ReleaseRepository releaseRepository) {
        this.resolver = new RelationshipsResolver(releaseApi, templateApi, riskApi, releaseRepository);
    }

    @GET
    @Path(value="graph/{releaseId:.+}")
    public Graph relationshipsGraph(@PathParam(value="releaseId") String releaseId) {
        logger.debug(String.format("Received request to resolving graph for release with id: %s", releaseId));
        return this.resolver.resolveGraph(releaseId);
    }
}

