import com.xebialabs.xlrelease.api.v1.forms.Comment


def abort_task(task_id, comment):
    taskApi.abortTask(task_id, com.xebialabs.xlrelease.api.v1.forms.Comment(comment))


def terminate_active_tasks_and_abort_release(release_id):
    try:
        releaseApi.getRelease(release_id)
    except Exception as e:
        logger.error("Failed to get release id '%s'" % release_id, bold=True)
        return False
    tasks = releaseApi.getActiveTasks(release_id)
    for task in tasks:
        if str(task.status) == 'IN_PROGRESS' and \
                str(task.type) in ["xlrelease.ScriptTask", "xlrelease.CustomScriptTask"]:
            try:
                abort_task(task.id, "Aborting of release forced the aborting of this task")
            except Exception as e:
                return False
    try:
        releaseApi.abort(release_id)
    except Exception as e:
        return False
    return True


processed = []
for rel_id in request.entity:
    if terminate_active_tasks_and_abort_release(rel_id):
        processed.append(rel_id)

response.entity = {"updatedIds": processed}
