/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.relationships.graph;

import com.xebialabs.xlrelease.relationships.graph.Edge;
import com.xebialabs.xlrelease.relationships.graph.Node;
import com.xebialabs.xlrelease.relationships.graph.RiskData;
import com.xebialabs.xlrelease.relationships.graph.TaskData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Graph {
    private Set<String> processedNodes = new HashSet<String>();
    private List<Node> nodes = new ArrayList<Node>();
    private List<Edge> edges = new ArrayList<Edge>();

    public void addEdge(String sourceId, String targetId, String taskName, Edge.Kind kind) {
        for (Edge e : this.edges) {
            if (!e.getSource().equalsIgnoreCase(sourceId) || !e.getTarget().equalsIgnoreCase(targetId)) continue;
            e.setName(e.getName() + ", " + taskName);
            return;
        }
        this.edges.add(new Edge(sourceId, targetId, taskName, kind));
    }

    public Node addNode(String id, String displayLabel, String status, String phase, int level, List<TaskData> failedTasks, List<TaskData> activeTasks, RiskData risk) {
        Node node = new Node(id, displayLabel, status, phase, level, failedTasks, activeTasks, risk);
        this.nodes.add(node);
        this.processedNodes.add(id);
        return node;
    }

    public boolean isNodeProcessed(String nid) {
        return this.processedNodes.contains(nid);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }
}

