#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from opsgenie.swagger_client import AlertApi
from opsgenie.swagger_client.models import *
from opsgenie.swagger_client.rest import ApiException
from java.text import SimpleDateFormat
from java.util import TimeZone, Locale, Calendar
from opsgenie_xlr import connect_to_opsgenie

connect_to_opsgenie(opsGenieConfig)
try:
    iso8601DateFormatter = SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'", Locale.ENGLISH)
    iso8601DateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"))

    if snoozeTime:
        tz = TimeZone.getTimeZone(opsGenieTimeZone)
        now = Calendar.getInstance(tz)
        now.add(Calendar.MINUTE, snoozeTime)
        inputDate = now.getTime()
    else:
        inputDateFormatter = SimpleDateFormat(opsGenieFormat, Locale.ENGLISH)
        inputDateFormatter.setTimeZone(TimeZone.getTimeZone(opsGenieTimeZone))
        inputDate = inputDateFormatter.parse(endTime)

    formatted_end_date = iso8601DateFormatter.format(inputDate)
    body = SnoozeAlertRequest(
        source=source,
        user=user,
        note=note,
        end_time=formatted_end_date)

    response = AlertApi().snooze_alert(
            identifier=alertIdentifier,
            identifier_type=alertIdentifierType,
            body=body)
    if response.request_id:
        print "```Alert %s is snoozed till %s %s```" % (alertIdentifier, endTime, opsGenieTimeZone)
except ApiException as err:
    print("```Exception when calling AlertApi->snooze_alert: %s\n```" % err)
    sys.exit(1)
