#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

#
import sys
from opsgenie_xlr import connect_to_opsgenie
from opsgenie.swagger_client import AlertApi
from opsgenie.swagger_client.models import *
from opsgenie.swagger_client.rest import ApiException
from opsgenie.swagger_client.models.team_recipient import TeamRecipient

connect_to_opsgenie(opsGenieConfig)
teams_list = []
for team in teams:
    teams_list.append(TeamRecipient(name=team))
action_list = []
for action in actions:
    action_list.append(action)
tag_list = []
for tag in tags:
    tag_list.append(tag)
recipient_list = []
for key, val in recipients.items():
    recipient_list.append(TeamRecipient(name=key.strip(), type=val.strip()))

body = CreateAlertRequest(
        message=message,
        alias=alias,
        description=description,
        teams=teams_list,
        visible_to=recipient_list,
        actions=action_list,
        tags=tag_list,
        entity=entity,
        priority=priority,
        source=source,
        user=user,
        note=note)
try:
    response = AlertApi().create_alert(body=body)
    request_id = response.request_id
    alert_response = AlertApi().get_request_status(request_id=request_id)
    print "```Alert created with id %s.```" % alert_response.data.alert_id
    alertId =alert_response.data.alert_id
except ApiException as err:
    print("```Exception when calling AlertApi->create_alert: %s\n```" % err)
    sys.exit(1)