#
# Copyright (c) XebiaLabs B.V., All rights reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

#
import sys
from opsgenie_xlr import connect_to_opsgenie
from opsgenie.swagger_client import AlertApi
from opsgenie.swagger_client.models import *
from opsgenie.swagger_client.rest import ApiException
from opsgenie.swagger_client.models.team_recipient import TeamRecipient

connect_to_opsgenie(opsGenieConfig)
teams_list = []
for team in teams:
    teams_list.append(TeamRecipient(name=team))
action_list = []
for action in actions:
    action_list.append(action)
tag_list = []
for tag in tags:
    tag_list.append(tag)
recipient_list = []
for key, val in recipients.items():
    recipient_list.append(TeamRecipient(name=key.strip(), type=val.strip()))

body = CreateAlertRequest(
        message=message,
        alias=alias,
        description=description,
        teams=teams_list,
        visible_to=recipient_list,
        actions=action_list,
        tags=tag_list,
        entity=entity,
        priority=priority,
        source=source,
        user=user,
        note=note)
try:
    response = AlertApi().create_alert(body=body)
    request_id = response.request_id
    alert_response = AlertApi().get_request_status(request_id=request_id)
    print "```Alert created with id %s.```" % alert_response.data.alert_id
    alertId =alert_response.data.alert_id
except ApiException as err:
    print("```Exception when calling AlertApi->create_alert: %s\n```" % err)
    sys.exit(1)