#
# Copyright (c) XebiaLabs B.V., All rights reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

import sys
from opsgenie_xlr import connect_to_opsgenie
from opsgenie.swagger_client import AlertApi
from opsgenie.swagger_client.rest import ApiException

connect_to_opsgenie(configuration)

try:
    response = AlertApi().list_alerts(
            limit=5,
            query='status: open',
            order='desc',
            sort='createdAt')
    if not response.data:
        sys.exit(1)

except ApiException as err:
    print("```Unable to Connect to OpsGenie: Exception %s\n```" % err)
    sys.exit(1)

