#
# Copyright (c) XebiaLabs B.V., All rights reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

from opsgenie.swagger_client import AlertApi
from opsgenie.swagger_client.models import *
from opsgenie.swagger_client.rest import ApiException
from java.text import SimpleDateFormat
from java.util import TimeZone, Locale, Calendar
from opsgenie_xlr import connect_to_opsgenie

connect_to_opsgenie(opsGenieConfig)
try:
    iso8601DateFormatter = SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'", Locale.ENGLISH)
    iso8601DateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"))

    if snoozeTime:
        tz = TimeZone.getTimeZone(opsGenieTimeZone)
        now = Calendar.getInstance(tz)
        now.add(Calendar.MINUTE, snoozeTime)
        inputDate = now.getTime()
    else:
        inputDateFormatter = SimpleDateFormat(opsGenieFormat, Locale.ENGLISH)
        inputDateFormatter.setTimeZone(TimeZone.getTimeZone(opsGenieTimeZone))
        inputDate = inputDateFormatter.parse(endTime)

    formatted_end_date = iso8601DateFormatter.format(inputDate)
    body = SnoozeAlertRequest(
        source=source,
        user=user,
        note=note,
        end_time=formatted_end_date)

    response = AlertApi().snooze_alert(
            identifier=alertIdentifier,
            identifier_type=alertIdentifierType,
            body=body)
    if response.request_id:
        print "```Alert %s is snoozed till %s %s```" % (alertIdentifier, endTime, opsGenieTimeZone)
except ApiException as err:
    print("```Exception when calling AlertApi->snooze_alert: %s\n```" % err)
    sys.exit(1)
