# coding: utf-8

"""
    OpsGenie REST API

    OpsGenie API Description

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

# python 2 and python 3 compatibility library
from six import iteritems

from ..api_client import ApiClient
from ..configuration import Configuration


class AlertApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def acknowledge_alert(self, identifier, **kwargs):
        """
        Acknowledge Alert
        Acknowledges alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.acknowledge_alert(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param AcknowledgeAlertRequest body: Request payload of acknowledging alert action
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.acknowledge_alert_with_http_info(identifier, **kwargs)
        else:
            (data) = self.acknowledge_alert_with_http_info(identifier, **kwargs)
            return data

    def acknowledge_alert_with_http_info(self, identifier, **kwargs):
        """
        Acknowledge Alert
        Acknowledges alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.acknowledge_alert_with_http_info(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param AcknowledgeAlertRequest body: Request payload of acknowledging alert action
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'identifier_type', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method acknowledge_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `acknowledge_alert`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/acknowledge', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def add_details(self, identifier, body, **kwargs):
        """
        Add Alert Details
        Add details to the alert
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_details(identifier, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param AddAlertDetailsRequest body: Request payload of adding alert details action (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_details_with_http_info(identifier, body, **kwargs)
        else:
            (data) = self.add_details_with_http_info(identifier, body, **kwargs)
            return data

    def add_details_with_http_info(self, identifier, body, **kwargs):
        """
        Add Alert Details
        Add details to the alert
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_details_with_http_info(identifier, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param AddAlertDetailsRequest body: Request payload of adding alert details action (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body', 'identifier_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `add_details`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_details`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/details', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def add_note(self, identifier, body, **kwargs):
        """
        Add Alert Note
        Adds note to alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_note(identifier, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param AddAlertNoteRequest body: Request payload of adding note to alert action (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_note_with_http_info(identifier, body, **kwargs)
        else:
            (data) = self.add_note_with_http_info(identifier, body, **kwargs)
            return data

    def add_note_with_http_info(self, identifier, body, **kwargs):
        """
        Add Alert Note
        Adds note to alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_note_with_http_info(identifier, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param AddAlertNoteRequest body: Request payload of adding note to alert action (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body', 'identifier_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_note" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `add_note`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_note`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/notes', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def add_saved_searches(self, body, **kwargs):
        """
        Add Saved Search
        Create saved search with given fields
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_saved_searches(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AddSavedSearchRequest body: Request payload of creating saved search (required)
        :return: AddSavedSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_saved_searches_with_http_info(body, **kwargs)
        else:
            (data) = self.add_saved_searches_with_http_info(body, **kwargs)
            return data

    def add_saved_searches_with_http_info(self, body, **kwargs):
        """
        Add Saved Search
        Create saved search with given fields
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_saved_searches_with_http_info(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AddSavedSearchRequest body: Request payload of creating saved search (required)
        :return: AddSavedSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_saved_searches" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_saved_searches`")

        collection_formats = {}

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/saved-searches', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AddSavedSearchResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def add_tags(self, identifier, body, **kwargs):
        """
        Add Alert Tags
        Add tags to the alert
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_tags(identifier, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param AddAlertTagsRequest body: Request payload of creating alert tags action (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_tags_with_http_info(identifier, body, **kwargs)
        else:
            (data) = self.add_tags_with_http_info(identifier, body, **kwargs)
            return data

    def add_tags_with_http_info(self, identifier, body, **kwargs):
        """
        Add Alert Tags
        Add tags to the alert
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_tags_with_http_info(identifier, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param AddAlertTagsRequest body: Request payload of creating alert tags action (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body', 'identifier_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `add_tags`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_tags`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/tags', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def add_team(self, identifier, body, **kwargs):
        """
        Add Team
        Add team to alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_team(identifier, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param AddAlertTeamRequest body: Request payload of adding team to alert action (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_team_with_http_info(identifier, body, **kwargs)
        else:
            (data) = self.add_team_with_http_info(identifier, body, **kwargs)
            return data

    def add_team_with_http_info(self, identifier, body, **kwargs):
        """
        Add Team
        Add team to alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_team_with_http_info(identifier, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param AddAlertTeamRequest body: Request payload of adding team to alert action (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body', 'identifier_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_team" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `add_team`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_team`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/teams', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def assign_alert(self, identifier, body, **kwargs):
        """
        Assign Alert
        Assign alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.assign_alert(identifier, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param AssignAlertRequest body: Request payload of assigning alert action (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.assign_alert_with_http_info(identifier, body, **kwargs)
        else:
            (data) = self.assign_alert_with_http_info(identifier, body, **kwargs)
            return data

    def assign_alert_with_http_info(self, identifier, body, **kwargs):
        """
        Assign Alert
        Assign alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.assign_alert_with_http_info(identifier, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param AssignAlertRequest body: Request payload of assigning alert action (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body', 'identifier_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `assign_alert`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `assign_alert`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/assign', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def close_alert(self, identifier, **kwargs):
        """
        Close Alert
        Closes alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.close_alert(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param CloseAlertRequest body: Request payload of closing alert action
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.close_alert_with_http_info(identifier, **kwargs)
        else:
            (data) = self.close_alert_with_http_info(identifier, **kwargs)
            return data

    def close_alert_with_http_info(self, identifier, **kwargs):
        """
        Close Alert
        Closes alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.close_alert_with_http_info(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param CloseAlertRequest body: Request payload of closing alert action
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'identifier_type', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method close_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `close_alert`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/close', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_alert(self, body, **kwargs):
        """
        Create Alert
        Creates a new alert
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_alert(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateAlertRequest body: Request payload of created alert (required)
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_alert_with_http_info(body, **kwargs)
        else:
            (data) = self.create_alert_with_http_info(body, **kwargs)
            return data

    def create_alert_with_http_info(self, body, **kwargs):
        """
        Create Alert
        Creates a new alert
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_alert_with_http_info(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateAlertRequest body: Request payload of created alert (required)
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_alert`")

        collection_formats = {}

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_alert(self, identifier, **kwargs):
        """
        Delete Alert
        Deletes an alert using alert id, tiny id or alias
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_alert(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param str source: Display name of the request source
        :param str user: Display name of the request owner
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_alert_with_http_info(identifier, **kwargs)
        else:
            (data) = self.delete_alert_with_http_info(identifier, **kwargs)
            return data

    def delete_alert_with_http_info(self, identifier, **kwargs):
        """
        Delete Alert
        Deletes an alert using alert id, tiny id or alias
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_alert_with_http_info(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param str source: Display name of the request source
        :param str user: Display name of the request owner
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'identifier_type', 'source', 'user']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `delete_alert`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']
        if 'source' in params:
            query_params['source'] = params['source']
        if 'user' in params:
            query_params['user'] = params['user']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_details(self, identifier, keys, **kwargs):
        """
        Delete Alert Details
        Delete the details of an alert using alert id, tiny id or alias
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_details(identifier, keys, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param list[str] keys: Comma separated list of keys to remove from the custom properties of the alert (e.g. 'key1,key2') (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param str user: Display name of the request owner
        :param str note: Additional alert note to add
        :param str source: Display name of the request source
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_details_with_http_info(identifier, keys, **kwargs)
        else:
            (data) = self.delete_details_with_http_info(identifier, keys, **kwargs)
            return data

    def delete_details_with_http_info(self, identifier, keys, **kwargs):
        """
        Delete Alert Details
        Delete the details of an alert using alert id, tiny id or alias
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_details_with_http_info(identifier, keys, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param list[str] keys: Comma separated list of keys to remove from the custom properties of the alert (e.g. 'key1,key2') (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param str user: Display name of the request owner
        :param str note: Additional alert note to add
        :param str source: Display name of the request source
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'keys', 'identifier_type', 'user', 'note', 'source']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `delete_details`")
        # verify the required parameter 'keys' is set
        if ('keys' not in params) or (params['keys'] is None):
            raise ValueError("Missing the required parameter `keys` when calling `delete_details`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']
        if 'user' in params:
            query_params['user'] = params['user']
        if 'note' in params:
            query_params['note'] = params['note']
        if 'source' in params:
            query_params['source'] = params['source']
        if 'keys' in params:
            query_params['keys'] = params['keys']
            collection_formats['keys'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/details', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_saved_search(self, identifier, **kwargs):
        """
        Delete Saved Search
        Deletes saved search using given search identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_saved_search(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of the saved search which could be 'id' or 'name' (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', or 'name'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_saved_search_with_http_info(identifier, **kwargs)
        else:
            (data) = self.delete_saved_search_with_http_info(identifier, **kwargs)
            return data

    def delete_saved_search_with_http_info(self, identifier, **kwargs):
        """
        Delete Saved Search
        Deletes saved search using given search identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_saved_search_with_http_info(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of the saved search which could be 'id' or 'name' (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', or 'name'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'identifier_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_saved_search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `delete_saved_search`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/saved-searches/{identifier}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_tags(self, identifier, tags, **kwargs):
        """
        Delete Alert Tags
        Delete tags of the alert
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tags(identifier, tags, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param list[str] tags: Tags field of the given alert as comma seperated values (e.g. 'tag1,tag2') (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param str user: Display name of the request owner
        :param str note: Additional alert note to add
        :param str source: Display name of the request source
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_tags_with_http_info(identifier, tags, **kwargs)
        else:
            (data) = self.delete_tags_with_http_info(identifier, tags, **kwargs)
            return data

    def delete_tags_with_http_info(self, identifier, tags, **kwargs):
        """
        Delete Alert Tags
        Delete tags of the alert
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tags_with_http_info(identifier, tags, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param list[str] tags: Tags field of the given alert as comma seperated values (e.g. 'tag1,tag2') (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param str user: Display name of the request owner
        :param str note: Additional alert note to add
        :param str source: Display name of the request source
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tags', 'identifier_type', 'user', 'note', 'source']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `delete_tags`")
        # verify the required parameter 'tags' is set
        if ('tags' not in params) or (params['tags'] is None):
            raise ValueError("Missing the required parameter `tags` when calling `delete_tags`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']
        if 'user' in params:
            query_params['user'] = params['user']
        if 'note' in params:
            query_params['note'] = params['note']
        if 'source' in params:
            query_params['source'] = params['source']
        if 'tags' in params:
            query_params['tags'] = params['tags']
            collection_formats['tags'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/tags', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def escalate_alert(self, identifier, body, **kwargs):
        """
        Escalate Alert
        Escalate alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.escalate_alert(identifier, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param EscalateAlertToNextRequest body: Request payload of escalating alert action (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.escalate_alert_with_http_info(identifier, body, **kwargs)
        else:
            (data) = self.escalate_alert_with_http_info(identifier, body, **kwargs)
            return data

    def escalate_alert_with_http_info(self, identifier, body, **kwargs):
        """
        Escalate Alert
        Escalate alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.escalate_alert_with_http_info(identifier, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param EscalateAlertToNextRequest body: Request payload of escalating alert action (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body', 'identifier_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method escalate_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `escalate_alert`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `escalate_alert`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/escalate', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def execute_custom_action(self, identifier, action_name, **kwargs):
        """
        Custom Alert Action
        Custom actions for the alert
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.execute_custom_action(identifier, action_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str action_name: Name of the action to execute (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param ExecuteCustomAlertActionRequest body: Request payload of executing custom alert action
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.execute_custom_action_with_http_info(identifier, action_name, **kwargs)
        else:
            (data) = self.execute_custom_action_with_http_info(identifier, action_name, **kwargs)
            return data

    def execute_custom_action_with_http_info(self, identifier, action_name, **kwargs):
        """
        Custom Alert Action
        Custom actions for the alert
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.execute_custom_action_with_http_info(identifier, action_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str action_name: Name of the action to execute (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param ExecuteCustomAlertActionRequest body: Request payload of executing custom alert action
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'action_name', 'identifier_type', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method execute_custom_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `execute_custom_action`")
        # verify the required parameter 'action_name' is set
        if ('action_name' not in params) or (params['action_name'] is None):
            raise ValueError("Missing the required parameter `action_name` when calling `execute_custom_action`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']
        if 'action_name' in params:
            path_params['actionName'] = params['action_name']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/actions/{actionName}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_alert(self, identifier, **kwargs):
        """
        Get Alert
        Returns alert with given id, tiny id or alias
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_alert(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: GetAlertResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_alert_with_http_info(identifier, **kwargs)
        else:
            (data) = self.get_alert_with_http_info(identifier, **kwargs)
            return data

    def get_alert_with_http_info(self, identifier, **kwargs):
        """
        Get Alert
        Returns alert with given id, tiny id or alias
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_alert_with_http_info(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: GetAlertResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'identifier_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_alert`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='GetAlertResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_request_status(self, request_id, **kwargs):
        """
        Get Request Status of Alert
        Returns status of alert request
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_request_status(request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str request_id: Id of the request for its status (required)
        :return: GetRequestStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_request_status_with_http_info(request_id, **kwargs)
        else:
            (data) = self.get_request_status_with_http_info(request_id, **kwargs)
            return data

    def get_request_status_with_http_info(self, request_id, **kwargs):
        """
        Get Request Status of Alert
        Returns status of alert request
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_request_status_with_http_info(request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str request_id: Id of the request for its status (required)
        :return: GetRequestStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_request_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request_id' is set
        if ('request_id' not in params) or (params['request_id'] is None):
            raise ValueError("Missing the required parameter `request_id` when calling `get_request_status`")

        collection_formats = {}

        path_params = {}
        if 'request_id' in params:
            path_params['requestId'] = params['request_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/requests/{requestId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='GetRequestStatusResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_saved_search(self, identifier, **kwargs):
        """
        Get Saved Search
        Get saved search for the given search identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_saved_search(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of the saved search which could be 'id' or 'name' (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', or 'name'
        :return: GetSavedSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_saved_search_with_http_info(identifier, **kwargs)
        else:
            (data) = self.get_saved_search_with_http_info(identifier, **kwargs)
            return data

    def get_saved_search_with_http_info(self, identifier, **kwargs):
        """
        Get Saved Search
        Get saved search for the given search identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_saved_search_with_http_info(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of the saved search which could be 'id' or 'name' (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', or 'name'
        :return: GetSavedSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'identifier_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_saved_search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_saved_search`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/saved-searches/{identifier}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='GetSavedSearchResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_alerts(self, **kwargs):
        """
        List Alerts
        Returns list of alerts
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_alerts(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: Maximum number of items to provide in the result. Must be a positive integer value. Default value is 20 and maximum value is 100
        :param str sort: Name of the field that result set will be sorted by
        :param int offset: Start index of the result set (to apply pagination). Minimum value (and also default value) is 0
        :param str order: Sorting order of the result set
        :param str query: Search query to apply while filtering the alerts
        :param str search_identifier: Identifier of the saved search query to apply while filtering the alerts
        :param str search_identifier_type: Identifier type of the saved search query. Possible values are 'id', or 'name'
        :return: ListAlertsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_alerts_with_http_info(**kwargs)
        else:
            (data) = self.list_alerts_with_http_info(**kwargs)
            return data

    def list_alerts_with_http_info(self, **kwargs):
        """
        List Alerts
        Returns list of alerts
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_alerts_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: Maximum number of items to provide in the result. Must be a positive integer value. Default value is 20 and maximum value is 100
        :param str sort: Name of the field that result set will be sorted by
        :param int offset: Start index of the result set (to apply pagination). Minimum value (and also default value) is 0
        :param str order: Sorting order of the result set
        :param str query: Search query to apply while filtering the alerts
        :param str search_identifier: Identifier of the saved search query to apply while filtering the alerts
        :param str search_identifier_type: Identifier type of the saved search query. Possible values are 'id', or 'name'
        :return: ListAlertsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'sort', 'offset', 'order', 'query', 'search_identifier', 'search_identifier_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_alerts" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 100:
            raise ValueError(
                "Invalid value for parameter `limit` when calling `list_alerts`, must be a value less than or equal to `100`")
        if 'limit' in params and params['limit'] < 1:
            raise ValueError(
                "Invalid value for parameter `limit` when calling `list_alerts`, must be a value greater than or equal to `1`")
        if 'offset' in params and params['offset'] < 0:
            raise ValueError(
                "Invalid value for parameter `offset` when calling `list_alerts`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'sort' in params:
            query_params['sort'] = params['sort']
        if 'offset' in params:
            query_params['offset'] = params['offset']
        if 'order' in params:
            query_params['order'] = params['order']
        if 'query' in params:
            query_params['query'] = params['query']
        if 'search_identifier' in params:
            query_params['searchIdentifier'] = params['search_identifier']
        if 'search_identifier_type' in params:
            query_params['searchIdentifierType'] = params['search_identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListAlertsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_logs(self, identifier, **kwargs):
        """
        List Alert Logs
        List alert logs for the given alert identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_logs(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param str offset: Starting value of the offset property
        :param str direction: Page direction to apply for the given offset with 'next' and 'prev'
        :param int limit: Maximum number of items to provide in the result. Must be a positive integer value. Default value is 20 and maximum value is 100
        :param str order: Sorting order of the result set
        :return: ListAlertLogsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_logs_with_http_info(identifier, **kwargs)
        else:
            (data) = self.list_logs_with_http_info(identifier, **kwargs)
            return data

    def list_logs_with_http_info(self, identifier, **kwargs):
        """
        List Alert Logs
        List alert logs for the given alert identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_logs_with_http_info(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param str offset: Starting value of the offset property
        :param str direction: Page direction to apply for the given offset with 'next' and 'prev'
        :param int limit: Maximum number of items to provide in the result. Must be a positive integer value. Default value is 20 and maximum value is 100
        :param str order: Sorting order of the result set
        :return: ListAlertLogsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'identifier_type', 'offset', 'direction', 'limit', 'order']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `list_logs`")

        if 'limit' in params and params['limit'] < 1:
            raise ValueError(
                "Invalid value for parameter `limit` when calling `list_logs`, must be a value greater than or equal to `1`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']
        if 'offset' in params:
            query_params['offset'] = params['offset']
        if 'direction' in params:
            query_params['direction'] = params['direction']
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'order' in params:
            query_params['order'] = params['order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/logs', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListAlertLogsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_notes(self, identifier, **kwargs):
        """
        List Alert Notes
        List alert notes for the given alert identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_notes(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param str offset: Starting value of the offset property
        :param str direction: Page direction to apply for the given offset with 'next' and 'prev'
        :param int limit: Maximum number of items to provide in the result. Must be a positive integer value. Default value is 20 and maximum value is 100
        :param str order: Sorting order of the result set
        :return: ListAlertNotesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_notes_with_http_info(identifier, **kwargs)
        else:
            (data) = self.list_notes_with_http_info(identifier, **kwargs)
            return data

    def list_notes_with_http_info(self, identifier, **kwargs):
        """
        List Alert Notes
        List alert notes for the given alert identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_notes_with_http_info(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param str offset: Starting value of the offset property
        :param str direction: Page direction to apply for the given offset with 'next' and 'prev'
        :param int limit: Maximum number of items to provide in the result. Must be a positive integer value. Default value is 20 and maximum value is 100
        :param str order: Sorting order of the result set
        :return: ListAlertNotesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'identifier_type', 'offset', 'direction', 'limit', 'order']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_notes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `list_notes`")

        if 'limit' in params and params['limit'] < 1:
            raise ValueError(
                "Invalid value for parameter `limit` when calling `list_notes`, must be a value greater than or equal to `1`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']
        if 'offset' in params:
            query_params['offset'] = params['offset']
        if 'direction' in params:
            query_params['direction'] = params['direction']
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'order' in params:
            query_params['order'] = params['order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/notes', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListAlertNotesResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_recipients(self, identifier, **kwargs):
        """
        List Alert Recipients
        List alert recipients for the given alert identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_recipients(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: ListAlertRecipientsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_recipients_with_http_info(identifier, **kwargs)
        else:
            (data) = self.list_recipients_with_http_info(identifier, **kwargs)
            return data

    def list_recipients_with_http_info(self, identifier, **kwargs):
        """
        List Alert Recipients
        List alert recipients for the given alert identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_recipients_with_http_info(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: ListAlertRecipientsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'identifier_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_recipients" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `list_recipients`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/recipients', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListAlertRecipientsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_saved_searches(self, **kwargs):
        """
        Lists Saved Searches
        List all saved searches
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_saved_searches(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ListSavedSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_saved_searches_with_http_info(**kwargs)
        else:
            (data) = self.list_saved_searches_with_http_info(**kwargs)
            return data

    def list_saved_searches_with_http_info(self, **kwargs):
        """
        Lists Saved Searches
        List all saved searches
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_saved_searches_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ListSavedSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_saved_searches" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/saved-searches', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListSavedSearchResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def snooze_alert(self, identifier, body, **kwargs):
        """
        Snooze Alert
        Snooze alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.snooze_alert(identifier, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param SnoozeAlertRequest body: Request payload of snoozing alert action (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.snooze_alert_with_http_info(identifier, body, **kwargs)
        else:
            (data) = self.snooze_alert_with_http_info(identifier, body, **kwargs)
            return data

    def snooze_alert_with_http_info(self, identifier, body, **kwargs):
        """
        Snooze Alert
        Snooze alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.snooze_alert_with_http_info(identifier, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param SnoozeAlertRequest body: Request payload of snoozing alert action (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body', 'identifier_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method snooze_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `snooze_alert`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `snooze_alert`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/snooze', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def un_acknowledge_alert(self, identifier, **kwargs):
        """
        UnAcknowledge Alert
        UnAcknowledge alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.un_acknowledge_alert(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param UnAcknowledgeAlertRequest body: Request payload of unacknowledging alert action
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.un_acknowledge_alert_with_http_info(identifier, **kwargs)
        else:
            (data) = self.un_acknowledge_alert_with_http_info(identifier, **kwargs)
            return data

    def un_acknowledge_alert_with_http_info(self, identifier, **kwargs):
        """
        UnAcknowledge Alert
        UnAcknowledge alert with given identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.un_acknowledge_alert_with_http_info(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str identifier: Identifier of alert which could be alert id, tiny id or alert alias (required)
        :param str identifier_type: Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'
        :param UnAcknowledgeAlertRequest body: Request payload of unacknowledging alert action
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'identifier_type', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method un_acknowledge_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `un_acknowledge_alert`")

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = {}
        if 'identifier_type' in params:
            query_params['identifierType'] = params['identifier_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['GenieKey']

        return self.api_client.call_api('/v2/alerts/{identifier}/unacknowledge', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
