#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
from opsgenie.OpsgenieClient import OpsgenieClient
import com.xhaus.jyson.JysonCodec as json

from java.text import SimpleDateFormat
from java.util import TimeZone, Locale, Calendar

client = OpsgenieClient(opsGenieConfig, opsGenieConfig['apiKey'])
try:
    iso8601DateFormatter = SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX", Locale.ENGLISH)
    iso8601DateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"))

    if snoozeTime:
        tz = TimeZone.getTimeZone(opsGenieTimeZone)
        now = Calendar.getInstance(tz)
        now.add(Calendar.MINUTE, snoozeTime)
        inputDate = now.getTime()

    else:
        inputDateFormatter = SimpleDateFormat(opsGenieFormat, Locale.ENGLISH)
        inputDateFormatter.setTimeZone(TimeZone.getTimeZone(opsGenieTimeZone))
        inputDate = inputDateFormatter.parse(endTime)

    formatted_end_date = iso8601DateFormatter.format(inputDate)
    body = {
        "source":source,
        "user":user,
        "note":note,
        "endTime":formatted_end_date
    }

    jsonBody = json.dumps(body)
    data, status = client.httpPostUrl("alerts/" + alertIdentifier + "/snooze" + "?identifierType=" + alertIdentifierType, jsonBody)

    if data['requestId']:
        print "```Alert %s is snoozed till %s %s```" % (alertIdentifier, endTime, opsGenieTimeZone)

except Exception as err:
    print("```Exception when calling AlertApi->snooze_alert: %s\n```" % err)
    sys.exit(1)



