#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
from opsgenie.OpsgenieClient import OpsgenieClient

client = OpsgenieClient(opsGenieConfig, opsGenieConfig['apiKey'])

if source is not None and user is not None:
    data, status = client.httpDelete("alerts/" + alertIdentifier + "?identifierType="
                                     + alertIdentifierType + "?source=" + source + "?user=" + user)
elif source is None and user is not None:
    data, status = client.httpDelete("alerts/" + alertIdentifier + "?identifierType="
                                     + alertIdentifierType + "?user=" + user)
elif source is not None and user is None:
    data, status = client.httpDelete("alerts/" + alertIdentifier + "?identifierType="
                                     + alertIdentifierType + "?source=" + source)
else:
    data, status = client.httpDelete("alerts/" + alertIdentifier + "?identifierType=" + alertIdentifierType)

requestId = data['requestId']
reqData = client.httpGetUrl("alerts/requests/" + requestId)
if reqData['data']['isSuccess']:
    print("Alert with {0}: {1} deleted with HTTP return status: {2} and response: {3}"
          .format(alertIdentifierType, alertIdentifier, status, data))
else:
    sys.exit("Deleting Alert failed: {}".format(reqData))