#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import com.xhaus.jyson.JysonCodec as json
import sets
import sys
from xlrelease.HttpRequest import HttpRequest

HTTP_SUCCESS = sets.Set([200, 201, 202])


class OpsgenieClient(object):

    # HTTP Connection

    def __init__(self, httpConnection, apiKey):
        self.httpConnection = httpConnection
        self.httpRequest = HttpRequest(self.get_params(httpConnection))
        self.apiKey = apiKey
        self.headers = self._get_headers()

    @staticmethod
    def create_client(httpConnection, apiKey):
        return OpsgenieClient(httpConnection, apiKey)

    def _get_headers(self):
        return {"Accept": "application/json", "Content-Type": "application/json", "Authorization": 'GenieKey ' + self.apiKey}

    def get_params(self, configuration):
        return {
            'url': configuration['apiEndpoint'],
            'proxyHost': configuration['proxyHost'], 'proxyPort': configuration['proxyPort'],
            'proxyUsername': configuration['proxyUsername'], 'proxyPassword': configuration['proxyPassword']
        }

    def httpGetUrl(self, url):
        response = self.httpRequest.get(url, headers=self.headers)
        if response.getStatus() not in HTTP_SUCCESS:
            sys.exit(
                "Error from server, HTTP Return: %s, content %s" % (response.getStatus(), response.getResponse()))
        data = json.loads(response.getResponse())
        return data

    def httpPostUrl(self, url, body):
        response = self.httpRequest.post(url, headers=self.headers, body=body)
        if response.getStatus() in HTTP_SUCCESS:
            data = json.loads(response.getResponse())
            return data, response.getStatus()
        sys.exit("Error from server, HTTP Return: %s, content %s" % (response.getStatus(), response.getResponse()))

    def httpDelete(self, url):
        response = self.httpRequest.delete(url, headers=self.headers)
        if response.getStatus() in HTTP_SUCCESS:
            data = json.loads(response.getResponse())
            return data, response.getStatus()
        sys.exit("Error from server, HTTP Return: %s, content %s " %  (response.getStatus(), response.getResponse()))

    def listalerts(self, queryUrl):
        return self.httpGetUrl(queryUrl)

    def createAlert(self, url, body):
        return self.httpPostUrl(url, body)

    def enableDisableIntegration(self, integrationId, action):
        response = self.httpRequest.doRequest(method='POST', context='integrations/' + integrationId + '/' + action, headers=self.headers)
        if response.getStatus() in HTTP_SUCCESS:
            print("Integration {0}d: {1}".format(action, response.getResponse()))
        else:
            sys.exit("{0}ing Integration failed. HTTP Return: {1}, content {2}".format(action, response.getStatus(), response.getResponse()))
