#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xlropenshift.client.openshift_client import OpenShiftClient
import openshift.client
import kubernetes.client
import time

client = OpenShiftClient(server)
test_oapi_client = client.oapi_client()
api_client = client.client()

name = "{}-{}".format(project, deploymentConfName)

body = openshift.client.V1DeploymentRequest(name=deploymentConfName, force=True, latest=True)

response = test_oapi_client.create_namespaced_deployment_config_instantiate(name=name, namespace=project, body=body)
response = test_oapi_client.read_namespaced_deployment_config_status(deploymentConfName, project)

latest_version = response.status.latest_version

api_client = kubernetes.client.CoreV1Api(api_client)

status = 'Pending'
while status != "Complete":
    time.sleep(5)
    response = api_client.read_namespaced_replication_controller_status("{}-{}".format(deploymentConfName, latest_version) , project)
    status = response.metadata.annotations['openshift.io/deployment.phase']
    if status in ["Failed", "Unknown"]:
        raise RuntimeError("Deployment not successful status is : " + status)
    print "Current Status : {}".format(status)


deploymentId = "{}-{}".format(deploymentConfName, latest_version)