#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xlropenshift.client.openshift_client import OpenShiftClient
from kubernetes import client

v1_api = client.CoreV1Api(OpenShiftClient(server).client())
from urlparse import urlparse
import requests


def create_url(openshift_url, port, path_url):
    parsed = urlparse(openshift_url)
    return parsed._replace(netloc="{}:{}".format(parsed.hostname, port), scheme='http', path=path_url).geturl()


service = v1_api.read_namespaced_service(name=serviceName, namespace=projectName)
node_port_found = False
if service.spec and service.spec.ports:
    for port in service.spec.ports:
        if port.node_port:
            node_port_found = True
            url = create_url(server['serverUrl'], port.node_port, healthCheckUrl)
            print "Checking health url for {}".format(url)
            requests.get(url=url)
if not node_port_found:
    raise RuntimeError('node port not found in service')
