#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from com.xebialabs.xlrelease.plugin.openshift import LoaderUtil
from java.nio.file import Files, Paths, StandardCopyOption
import tempfile
import string

class CommonUtils(object):

    def __init__(self):
        pass

    @staticmethod
    def remove_none_keys(dictionary):
        return {k: v for k, v in dictionary.iteritems() if v is not None}

    @staticmethod
    def extract_file_from_jar(config_file):
        file_url = LoaderUtil.getResourceBySelfClassLoader(config_file)
        if file_url:
            tmp_file, tmp_abs_path = tempfile.mkstemp()
            tmp_file.close()
            Files.copy(file_url.openStream(), Paths.get(tmp_abs_path), StandardCopyOption.REPLACE_EXISTING)
            return tmp_abs_path
        else:
            return None

    @staticmethod
    def remove_certification_strip(cert):
        if "-----" in cert and " " in cert.split('-----')[2]:
            return CommonUtils.__cert_replace_spaces(cert).strip()
        else:
            return cert.strip()

    @staticmethod
    def __cert_replace_spaces(cert):
        splits = cert.split('-----')
        splits[2] = string.replace(splits[2], ' ', '\n')
        return '-----'.join(splits)