#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
from xlropenshift.client.openshift_client import OpenShiftClient
import kubernetes.client
import time

client = OpenShiftClient(server)

# OpenShift dynamic client
test_dyn_client = client.dyn_client()

api_client = client.client()
name = "{}-{}".format(project, deploymentConfName)

# Returning a ResourceInstance object
v1_deploymentConfigs = test_dyn_client.resources.get(api_version='apps.openshift.io/v1', kind='DeploymentConfig')

# DeploymentConfig instantiation
response = v1_deploymentConfigs.subresources["instantiate"].create(
                name=name,
                namespace=project,
                body={
                    "name": deploymentConfName,
                    "kind": "DeploymentRequest",
                    "apiVersion": "apps.openshift.io/v1",
                    "force": True,
                    "latest": True
                },
            )

latest_version = response.status.latestVersion
api_client = kubernetes.client.CoreV1Api(api_client)

status = 'Pending'
while status != "Complete":
    time.sleep(5)
    response = api_client.read_namespaced_replication_controller_status("{}-{}".format(deploymentConfName, latest_version) , project)
    status = response.metadata.annotations['openshift.io/deployment.phase']
    if status in ["Failed", "Unknown"]:
        raise RuntimeError("Deployment not successful status is : " + status)
    print "Current Status : {}".format(status)

deploymentId = "{}-{}".format(deploymentConfName, latest_version)