#
# Copyright (c) 2023. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
import json
from opa.OpaClient import OpaClient
from opa import add_code_compliance_plan_record
import datetime

responseLoad = OpaClient(opaServer).getPolicy(policyName=policyName)

pathfinal = "/v1"
for paths in responseLoad['result']['ast']['package']['path']:
    pathfinal = pathfinal + "/"+ str(paths['value'])
    
result = OpaClient(opaServer).evaluatePolicy(policyName=policyName,path=pathfinal,data=jsonInputForEvaluation)

evaluation_title = "Input Evaluated with : " + policyName

print(evaluation_title)

policyoutcome = ""

def add_record():
    evaluatedDate = datetime.datetime.now()
    add_code_compliance_plan_record(task_reporting_api=taskReportingApi, task=task,
                                    opaServer=opaServer,policy_name=policyName,type="Evaluate Policy",
                                    status=policyoutcome,analysisDate=evaluatedDate,complianceData=jsonInputForEvaluation)

if expectedOutput:
    if json.loads(expectedOutput) == result:
        print("Output checked with ExpectedOutput - Both Match")
        policyoutcome = "Evaluation Success"
        add_record()
    else:
        policyoutcome = "Evaluation Failed"
        add_record()
        exit("Expected Output did not match the Evaluation Output")



