#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
from octopus.OctopusClient import OctopusClient

client = OctopusClient(server, server['apiKey'])

if not releaseName:
    sys.exit("Please specify the release name.")

if not projectName:
    sys.exit("Please specify the project name.")

if not environmentName:
    sys.exit("Please specify the environment name.")

deploymentId, taskId = client.start_deploy(projectName, releaseName, environmentName, taskReportingApi, task, server)

deployment_details = client.httpGetUrl('/api/deployments/%s' % deploymentId)
# For Octopus installations leveraging a subfolder, the subfolder shows up in both the Links and the Release configuration URL
# URI segment deduplication is required for a usable endpoint
# Without the deduplication, the subfolder is built into the endpoint twice and the plugin gets a 404 response
taskUrl = None
if deployment_details["Links"]["Task"].split("/api/")[0] == "":
    taskUrl = deployment_details["Links"]["Task"]
else:
    # e.g. /octopus/api/tasks/ServerTasks-42 -> /api/tasks/ServerTasks-42
    taskUrl = "/api/".join([""] + deployment_details["Links"]["Task"].split("/api/")[1:])

task.schedule("octopus/wait-for-deploy.py",server['retryWaitingTime'])