#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
from octopus.OctopusClient import OctopusClient

client = OctopusClient(server, server['apiKey'])

def add_phase(phase_name):
    phase = phaseApi.newPhase(phase_name)
    phase = phaseApi.addPhase(release.id, phase)
    return phase

def create_task(taskType, taskName):
    task = taskApi.newTask(taskType)
    task.title = taskName
    return task

def add_property_to_task(task, property, value):
    task.pythonScript.setProperty(property, value)

def create_deploy_task(dep_target, projectName):
    deploy_task = create_task("octopus.Deploy", "Deploy to %s " % dep_target)
    add_property_to_task(deploy_task, "releaseName", "")
    add_property_to_task(deploy_task, "projectName", projectName)
    add_property_to_task(deploy_task, "releaseName", "${octopus_release_name}")
    add_property_to_task(deploy_task, "environmentName", dep_target)
    return deploy_task

def create_release_task(projectName):
    release_task = create_task("octopus.CreateRelease", "Create Release")
    add_property_to_task(release_task, "project", projectName)
    add_property_to_task(release_task, "releaseName", "${octopus_release_name}")
    add_property_to_task(release_task, "releaseId", "${octopus_release_id}")
    return release_task

#Create phase
phase_name = "Create Release Phase"
phase = add_phase(phase_name)

#create manual task
manual_task = create_task("xlrelease.Task", phase_name)

# add manual task
taskApi.addTask(phase.id, manual_task)

#create release task
release_task = create_release_task(projectName)

#add release task
taskApi.addTask(phase.id, release_task)

#call get lifecycle
lifecycle = client.get_lifecyle(lifecycleId)

#retrieve all environments in a map
environments_dic = {}
environments = client.get_all_environments()
for env in environments:
    environments_dic[env["Id"]] = env["Name"]

#process phases
for p in lifecycle['Phases']:
    #list for target environemnts
    environments_targets_list = []
    for d in p["AutomaticDeploymentTargets"]:
        environments_targets_list.append(d)
    if includeOptionalDeploymentTargets is True:
        for dp in p["OptionalDeploymentTargets"]:
            environments_targets_list.append(dp)

    phase_name = p['Name']
    phase = add_phase(phase_name)

    task_execution_group_type = "Sequential"
    #add parallel group if more than one environment in a phase and parallel group is selected
    if createParallelGroup is True and len(environments_targets_list) > 1:
        task_execution_group_type = "Parallel"

    task_group = taskApi.newTask("xlrelease.%sGroup" % (task_execution_group_type))
    task_group.title = "%s Run Group" % (task_execution_group_type)

    if task_execution_group_type == "Parallel":
        manual_task = create_task("xlrelease.Task", "%s run for %s" % (task_execution_group_type, phase_name))
        taskApi.addTask(phase.id, manual_task)

    task_group = taskApi.addTask(phase.id, task_group)

    for dep_target in environments_targets_list:
        deploy_task = create_deploy_task(environments_dic[dep_target], projectName)
        if task_execution_group_type != "Parallel":
            manual_task = create_task("xlrelease.Task", "%s run for phase: %s " % (task_execution_group_type, phase_name))
            taskApi.addTask(task_group.id, manual_task)

        taskApi.addTask(task_group.id, deploy_task)
